/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.asyncsql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.asyncsql.AsyncSQLClient;
import io.vertx.rxjava.ext.sql.SQLOperations;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.asyncsql.MySQLClient.class)
public class MySQLClient
extends AsyncSQLClient {
    public static final TypeArg<MySQLClient> __TYPE_ARG = new TypeArg(obj -> new MySQLClient((io.vertx.ext.asyncsql.MySQLClient)obj), MySQLClient::getDelegate);
    private final io.vertx.ext.asyncsql.MySQLClient delegate;
    public static final String DEFAULT_POOL_NAME = "DEFAULT_MYSQL_POOL";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 3306;
    public static final String DEFAULT_DATABASE = "testdb";
    public static final String DEFAULT_USER = "vertx";
    public static final String DEFAULT_PASSWORD = "password";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final long DEFAULT_CONNECT_TIMEOUT = 10000L;
    public static final long DEFAULT_TEST_TIMEOUT = 10000L;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MySQLClient that = (MySQLClient)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MySQLClient(io.vertx.ext.asyncsql.MySQLClient delegate) {
        super((io.vertx.ext.asyncsql.AsyncSQLClient)delegate);
        this.delegate = delegate;
    }

    public MySQLClient(Object delegate) {
        super((io.vertx.ext.asyncsql.AsyncSQLClient)((io.vertx.ext.asyncsql.MySQLClient)delegate));
        this.delegate = (io.vertx.ext.asyncsql.MySQLClient)delegate;
    }

    public io.vertx.ext.asyncsql.MySQLClient getDelegate() {
        return this.delegate;
    }

    @Override
    public SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingle(sql, handler);
        return this;
    }

    @Override
    @Deprecated
    public Observable<JsonArray> querySingleObservable(String sql) {
        ObservableFuture<JsonArray> handler = RxHelper.observableFuture();
        this.querySingle(sql, handler.toHandler());
        return handler;
    }

    @Override
    public Single<JsonArray> rxQuerySingle(String sql) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.querySingle(sql, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    @Override
    public SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.querySingleWithParams(sql, arguments, handler);
        return this;
    }

    @Override
    @Deprecated
    public Observable<JsonArray> querySingleWithParamsObservable(String sql, JsonArray arguments) {
        ObservableFuture<JsonArray> handler = RxHelper.observableFuture();
        this.querySingleWithParams(sql, arguments, handler.toHandler());
        return handler;
    }

    @Override
    public Single<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.querySingleWithParams(sql, arguments, (Handler<AsyncResult<JsonArray>>)fut)));
    }

    public static AsyncSQLClient createNonShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config) {
        AsyncSQLClient ret = AsyncSQLClient.newInstance(io.vertx.ext.asyncsql.MySQLClient.createNonShared((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public static AsyncSQLClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config, String poolName) {
        AsyncSQLClient ret = AsyncSQLClient.newInstance(io.vertx.ext.asyncsql.MySQLClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config, (String)poolName));
        return ret;
    }

    public static AsyncSQLClient createShared(io.vertx.rxjava.core.Vertx vertx, JsonObject config) {
        AsyncSQLClient ret = AsyncSQLClient.newInstance(io.vertx.ext.asyncsql.MySQLClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public static MySQLClient newInstance(io.vertx.ext.asyncsql.MySQLClient arg) {
        return arg != null ? new MySQLClient(arg) : null;
    }
}

