/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.rabbitmq;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.rabbitmq.RabbitMQConsumer;
import java.util.Map;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {
    public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg(obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient)obj), RabbitMQClient::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQClient that = (RabbitMQClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    public RabbitMQClient(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
    }

    public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
        return this.delegate;
    }

    public static RabbitMQClient create(io.vertx.rxjava.core.Vertx vertx) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RabbitMQClient create(io.vertx.rxjava.core.Vertx vertx, RabbitMQOptions config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate(), (RabbitMQOptions)config));
        return ret;
    }

    public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicAck(deliveryTag, multiple, resultHandler);
    }

    @Deprecated
    public Observable<JsonObject> basicAckObservable(long deliveryTag, boolean multiple) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.basicAck(deliveryTag, multiple, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxBasicAck(long deliveryTag, boolean multiple) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicAck(deliveryTag, multiple, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
    }

    @Deprecated
    public Observable<JsonObject> basicNackObservable(long deliveryTag, boolean multiple, boolean requeue) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.basicNack(deliveryTag, multiple, requeue, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public void basicGet(String queue, boolean autoAck, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.basicGet(queue, autoAck, resultHandler);
    }

    @Deprecated
    public Observable<JsonObject> basicGetObservable(String queue, boolean autoAck) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.basicGet(queue, autoAck, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxBasicGet(String queue, boolean autoAck) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicGet(queue, autoAck, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    @Deprecated
    public void basicConsume(String queue, String address, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.basicConsume(queue, address, resultHandler);
    }

    @Deprecated
    public Observable<String> basicConsumeObservable(String queue, String address) {
        ObservableFuture<String> resultHandler = RxHelper.observableFuture();
        this.basicConsume(queue, address, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<String> rxBasicConsume(String queue, String address) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicConsume(queue, address, (Handler<AsyncResult<String>>)fut)));
    }

    @Deprecated
    public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.basicConsume(queue, address, autoAck, resultHandler);
    }

    @Deprecated
    public Observable<String> basicConsumeObservable(String queue, String address, boolean autoAck) {
        ObservableFuture<String> resultHandler = RxHelper.observableFuture();
        this.basicConsume(queue, address, autoAck, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<String> rxBasicConsume(String queue, String address, boolean autoAck) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicConsume(queue, address, autoAck, (Handler<AsyncResult<String>>)fut)));
    }

    @Deprecated
    public void basicConsume(String queue, String address, boolean autoAck, Handler<AsyncResult<String>> resultHandler, Handler<Throwable> errorHandler) {
        this.delegate.basicConsume(queue, address, autoAck, resultHandler, errorHandler);
    }

    @Deprecated
    public void basicCancel(String consumerTag) {
        this.delegate.basicCancel(consumerTag);
    }

    @Deprecated
    public void basicCancel(String consumerTag, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicCancel(consumerTag, resultHandler);
    }

    @Deprecated
    public Observable<Void> basicCancelObservable(String consumerTag) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.basicCancel(consumerTag, resultHandler.toHandler());
        return resultHandler;
    }

    @Deprecated
    public Single<Void> rxBasicCancel(String consumerTag) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicCancel(consumerTag, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicConsumer(String queue, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    @Deprecated
    public Observable<RabbitMQConsumer> basicConsumerObservable(String queue) {
        ObservableFuture<RabbitMQConsumer> resultHandler = RxHelper.observableFuture();
        this.basicConsumer(queue, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicConsumer(queue, (Handler<AsyncResult<RabbitMQConsumer>>)fut)));
    }

    public void basicConsumer(String queue, QueueOptions options, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue, options, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    @Deprecated
    public Observable<RabbitMQConsumer> basicConsumerObservable(String queue, QueueOptions options) {
        ObservableFuture<RabbitMQConsumer> resultHandler = RxHelper.observableFuture();
        this.basicConsumer(queue, options, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue, QueueOptions options) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicConsumer(queue, options, (Handler<AsyncResult<RabbitMQConsumer>>)fut)));
    }

    public void basicPublish(String exchange, String routingKey, JsonObject message, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, message, resultHandler);
    }

    @Deprecated
    public Observable<Void> basicPublishObservable(String exchange, String routingKey, JsonObject message) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.basicPublish(exchange, routingKey, message, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxBasicPublish(String exchange, String routingKey, JsonObject message) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicPublish(exchange, routingKey, message, (Handler<AsyncResult<Void>>)fut)));
    }

    public void confirmSelect(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.confirmSelect(resultHandler);
    }

    @Deprecated
    public Observable<Void> confirmSelectObservable() {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.confirmSelect(resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxConfirmSelect() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.confirmSelect((Handler<AsyncResult<Void>>)fut)));
    }

    public void waitForConfirms(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(resultHandler);
    }

    @Deprecated
    public Observable<Void> waitForConfirmsObservable() {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.waitForConfirms(resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxWaitForConfirms() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.waitForConfirms((Handler<AsyncResult<Void>>)fut)));
    }

    public void waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(timeout, resultHandler);
    }

    @Deprecated
    public Observable<Void> waitForConfirmsObservable(long timeout) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.waitForConfirms(timeout, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxWaitForConfirms(long timeout) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.waitForConfirms(timeout, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicQos(int prefetchCount, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, resultHandler);
    }

    @Deprecated
    public Observable<Void> basicQosObservable(int prefetchCount) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.basicQos(prefetchCount, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxBasicQos(int prefetchCount) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicQos(prefetchCount, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicQos(int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, global, resultHandler);
    }

    @Deprecated
    public Observable<Void> basicQosObservable(int prefetchCount, boolean global) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.basicQos(prefetchCount, global, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxBasicQos(int prefetchCount, boolean global) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicQos(prefetchCount, global, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchSize, prefetchCount, global, resultHandler);
    }

    @Deprecated
    public Observable<Void> basicQosObservable(int prefetchSize, int prefetchCount, boolean global) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.basicQos(prefetchSize, prefetchCount, global, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxBasicQos(int prefetchSize, int prefetchCount, boolean global) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.basicQos(prefetchSize, prefetchCount, global, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler);
    }

    @Deprecated
    public Observable<Void> exchangeDeclareObservable(String exchange, String type, boolean durable, boolean autoDelete) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeDeclare(exchange, type, durable, autoDelete, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler);
    }

    @Deprecated
    public Observable<Void> exchangeDeclareObservable(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeDeclare(exchange, type, durable, autoDelete, config, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDelete(exchange, resultHandler);
    }

    @Deprecated
    public Observable<Void> exchangeDeleteObservable(String exchange) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.exchangeDelete(exchange, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxExchangeDelete(String exchange) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeDelete(exchange, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeBind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source, routingKey, resultHandler);
    }

    @Deprecated
    public Observable<Void> exchangeBindObservable(String destination, String source, String routingKey) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.exchangeBind(destination, source, routingKey, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxExchangeBind(String destination, String source, String routingKey) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeBind(destination, source, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source, routingKey, arguments, resultHandler);
    }

    @Deprecated
    public Observable<Void> exchangeBindObservable(String destination, String source, String routingKey, Map<String, Object> arguments) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.exchangeBind(destination, source, routingKey, arguments, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxExchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeBind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeUnbind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source, routingKey, resultHandler);
    }

    @Deprecated
    public Observable<Void> exchangeUnbindObservable(String destination, String source, String routingKey) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.exchangeUnbind(destination, source, routingKey, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxExchangeUnbind(String destination, String source, String routingKey) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeUnbind(destination, source, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source, routingKey, arguments, resultHandler);
    }

    @Deprecated
    public Observable<Void> exchangeUnbindObservable(String destination, String source, String routingKey, Map<String, Object> arguments) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.exchangeUnbind(destination, source, routingKey, arguments, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxExchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.exchangeUnbind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclareAuto(resultHandler);
    }

    @Deprecated
    public Observable<JsonObject> queueDeclareAutoObservable() {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.queueDeclareAuto(resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxQueueDeclareAuto() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDeclareAuto((Handler<AsyncResult<JsonObject>>)fut)));
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
    }

    @Deprecated
    public Observable<JsonObject> queueDeclareObservable(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDeclare(queue, durable, exclusive, autoDelete, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler);
    }

    @Deprecated
    public Observable<JsonObject> queueDeclareObservable(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDeclare(queue, durable, exclusive, autoDelete, config, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public void queueDelete(String queue, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDelete(queue, resultHandler);
    }

    @Deprecated
    public Observable<JsonObject> queueDeleteObservable(String queue) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.queueDelete(queue, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxQueueDelete(String queue) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDelete(queue, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
    }

    @Deprecated
    public Observable<JsonObject> queueDeleteIfObservable(String queue, boolean ifUnused, boolean ifEmpty) {
        ObservableFuture<JsonObject> resultHandler = RxHelper.observableFuture();
        this.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<JsonObject> rxQueueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueDeleteIf(queue, ifUnused, ifEmpty, (Handler<AsyncResult<JsonObject>>)fut)));
    }

    public void queueBind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue, exchange, routingKey, resultHandler);
    }

    @Deprecated
    public Observable<Void> queueBindObservable(String queue, String exchange, String routingKey) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.queueBind(queue, exchange, routingKey, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxQueueBind(String queue, String exchange, String routingKey) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueBind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue, exchange, routingKey, arguments, resultHandler);
    }

    @Deprecated
    public Observable<Void> queueBindObservable(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.queueBind(queue, exchange, routingKey, arguments, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxQueueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueBind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueUnbind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueUnbind(queue, exchange, routingKey, resultHandler);
    }

    @Deprecated
    public Observable<Void> queueUnbindObservable(String queue, String exchange, String routingKey) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.queueUnbind(queue, exchange, routingKey, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxQueueUnbind(String queue, String exchange, String routingKey) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueUnbind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueUnbind(queue, exchange, routingKey, arguments, resultHandler);
    }

    @Deprecated
    public Observable<Void> queueUnbindObservable(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.queueUnbind(queue, exchange, routingKey, arguments, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxQueueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.queueUnbind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)fut)));
    }

    public void messageCount(String queue, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.messageCount(queue, resultHandler);
    }

    @Deprecated
    public Observable<Long> messageCountObservable(String queue) {
        ObservableFuture<Long> resultHandler = RxHelper.observableFuture();
        this.messageCount(queue, resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Long> rxMessageCount(String queue) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.messageCount(queue, (Handler<AsyncResult<Long>>)fut)));
    }

    public void start(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.start(resultHandler);
    }

    @Deprecated
    public Observable<Void> startObservable() {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.start(resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxStart() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.start((Handler<AsyncResult<Void>>)fut)));
    }

    public void stop(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.stop(resultHandler);
    }

    @Deprecated
    public Observable<Void> stopObservable() {
        ObservableFuture<Void> resultHandler = RxHelper.observableFuture();
        this.stop(resultHandler.toHandler());
        return resultHandler;
    }

    public Single<Void> rxStop() {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.stop((Handler<AsyncResult<Void>>)fut)));
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

