/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.js.test;

import io.vertx.rx.js.test.VertxAssert;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class JsIntegrationTest
extends VertxTestBase {
    public static VertxAssert current;

    public void before() throws Exception {
        super.before();
        current = new VertxAssert(){

            @Override
            public void testComplete() {
                JsIntegrationTest.this.testComplete();
            }

            @Override
            public void assertEquals(Object expected, Object actual) {
                JsIntegrationTest.this.assertEquals(expected, actual);
            }

            @Override
            public void assertEquals(long expected, long actual) {
                JsIntegrationTest.this.assertEquals(expected, actual);
            }

            @Override
            public void assertTrue(boolean b) {
                JsIntegrationTest.this.assertTrue(b);
            }

            @Override
            public void assertFalse(boolean b) {
                JsIntegrationTest.this.assertFalse(b);
            }

            @Override
            public void fail(String msg) {
                JsIntegrationTest.this.fail(msg);
            }
        };
    }

    @Test
    public void testConsumeBodyStream() throws Throwable {
        this.deployTest("test_consume_body_stream.js");
    }

    @Test
    public void testAdaptItem() throws Throwable {
        this.deployTest("test_adapt_item.js");
    }

    @Test
    public void testConsumerRegistration() throws Throwable {
        this.deployTest("test_consumer_registration.js");
    }

    @Test
    public void testCompleted() throws Throwable {
        this.deployTest("test_completed.js");
    }

    @Test
    public void testSubscribeTwice() throws Throwable {
        this.deployTest("test_subscribe_twice.js");
    }

    @Test
    public void testObservableFuture() throws Throwable {
        this.deployTest("test_observable_future.js");
    }

    @Test
    public void testObserverToFuture() throws Throwable {
        this.deployTest("test_observer_to_future.js");
    }

    @Test
    public void testObservableHandler() throws Throwable {
        this.deployTest("test_observable_handler.js");
    }

    @Test
    public void testObserverToHandler() throws Throwable {
        this.deployTest("test_observer_to_handler.js");
    }

    @Test
    public void testScheduledTimer() throws Throwable {
        this.deployTest("test_scheduled_timer.js");
    }

    @Test
    public void testScheduledBuffer() throws Throwable {
        this.deployTest("test_scheduled_buffer.js");
    }

    @Test
    public void testConcat() throws Throwable {
        this.deployTest("test_concat.js");
    }

    @Test
    public void testTimeMap() throws Throwable {
        this.deployTest("test_time_map.js");
    }

    @Test
    public void testHttpClient() throws Throwable {
        this.deployTest("test_http_client.js");
    }

    @Test
    public void testHttpClientFlatMap() throws Throwable {
        this.deployTest("test_http_client_flatmap.js");
    }

    @Test
    public void testWebsocketClient() throws Throwable {
        this.deployTest("test_websocket_client.js");
    }

    @Test
    public void testWebsocketClientFlatMap() throws Throwable {
        this.deployTest("test_websocket_client_flatmap.js");
    }

    private void deployTest(String test) {
        this.vertx.deployVerticle(test, ar -> {
            if (!ar.succeeded()) {
                Throwable cause = ar.cause();
                cause.printStackTrace();
                this.fail(cause.getMessage());
            }
        });
        this.await();
    }
}

