/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.kubernetes;

import com.jayway.awaitility.Awaitility;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceListBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.dsl.DelayPathable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOrOnceable;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import io.vertx.servicediscovery.kubernetes.KubernetesServiceImporter;
import io.vertx.servicediscovery.spi.ServiceImporter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class KubernetesServerTest {
    private Vertx vertx;
    private KubernetesMockServer server;
    private NamespacedKubernetesClient client;
    private int port;

    @Before
    public void setUp(TestContext tc) throws MalformedURLException {
        this.vertx = Vertx.vertx();
        this.vertx.exceptionHandler(tc.exceptionHandler());
        Service svc1 = this.getSimpleService("uuid-2", "my-service");
        Service svc2 = this.getHttpService();
        Service svc3 = this.getSimpleService("uid-3", "service3");
        this.server = this.getServer();
        ((TimesOrOnceable)((ReturnOrWebsocketable)((DelayPathable)this.server.expect().get()).withPath("/api/v1/namespaces/default/services")).andReturn(200, (Object)((ServiceListBuilder)((ServiceListBuilder)new ServiceListBuilder().addToItems(new Service[]{svc1, svc2})).withNewMetadata("1234", "/self")).build())).always();
        ((TimesOrOnceable)((ReturnOrWebsocketable)((DelayPathable)this.server.expect().get()).withPath("/api/v1/namespaces/default/services?watch=true&allowWatchBookmarks=true&resourceVersion=1234")).andReturnChunked(200, new Object[]{new WatchEvent((KubernetesResource)svc3, "ADDED"), "\n", new WatchEvent((KubernetesResource)svc1, "DELETED"), "\n", new WatchEvent(this.getUpdatedHttpService(), "MODIFIED"), "\n", new WatchEvent((KubernetesResource)this.addLabelFooBar(this.getSimpleService("uid-3", "service3")), "MODIFIED"), "\n"})).once();
        Service svc96 = this.getService96();
        ((TimesOrOnceable)((ReturnOrWebsocketable)((DelayPathable)this.server.expect().get()).withPath("/api/v1/namespaces/issue96/services")).andReturn(200, (Object)((ServiceListBuilder)((ServiceListBuilder)new ServiceListBuilder().addToItems(new Service[]{svc96})).withNewMetadata("1235", "/self")).build())).always();
        ((TimesOrOnceable)((ReturnOrWebsocketable)((DelayPathable)this.server.expect().get()).withPath("/api/v1/namespaces/issue96/services?watch=true&allowWatchBookmarks=true&resourceVersion=1235")).andReturnChunked(200, new Object[]{new WatchEvent((KubernetesResource)this.getUpdatedService96(), "MODIFIED"), "\n", new WatchEvent((KubernetesResource)this.getUpdatedService96(), "DELETED"), "\n"})).once();
        this.server.init();
        this.client = this.server.createClient();
        this.port = new URL(this.client.getConfiguration().getMasterUrl()).getPort();
    }

    @After
    public void tearDown() {
        this.vertx.exceptionHandler(null);
        this.server.destroy();
        this.vertx.close();
    }

    public KubernetesMockServer getServer() {
        return new KubernetesMockServer(false);
    }

    private JsonObject config() {
        String token = this.client.getConfiguration().getOauthToken();
        if (token == null) {
            token = "some-token";
        }
        return new JsonObject().put("token", (Object)token).put("host", (Object)"localhost").put("ssl", (Object)false).put("port", (Object)this.port);
    }

    @Test
    public void testInitialRetrieval(TestContext tc) {
        Async async = tc.async();
        ServiceDiscovery discovery = ServiceDiscovery.create((Vertx)this.vertx, (ServiceDiscoveryOptions)new ServiceDiscoveryOptions());
        discovery.registerServiceImporter((ServiceImporter)new KubernetesServiceImporter(), this.config().copy().put("namespace", (Object)"default"), ar -> {
            if (ar.failed()) {
                tc.fail(ar.cause());
            } else {
                discovery.getRecords(s -> true, res -> {
                    if (res.failed()) {
                        tc.fail(res.cause());
                    } else {
                        tc.assertEquals((Object)2, (Object)((List)res.result()).size());
                        async.complete();
                    }
                });
            }
        });
    }

    @Test
    public void testWatch() {
        AtomicBoolean done = new AtomicBoolean();
        ServiceDiscovery discovery = ServiceDiscovery.create((Vertx)this.vertx, (ServiceDiscoveryOptions)new ServiceDiscoveryOptions());
        discovery.registerServiceImporter((ServiceImporter)new KubernetesServiceImporter(), this.config().copy().put("namespace", (Object)"default"), ar -> done.set(ar.succeeded()));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Awaitility.await().until(() -> {
            List<Record> records = this.getRecordsBlocking(discovery);
            try {
                ((AbstractListAssert)Assertions.assertThat(records).hasSize(2)).extracting(Record::getName).containsOnly((Object[])new String[]{"service3", "my-http-service"});
                Assertions.assertThat(records.stream().filter(record -> record.getName().equals("service3")).findFirst()).hasValueSatisfying(record -> {
                    AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)Assertions.assertThat((String)record.getMetadata().getString("foo")).isEqualTo((Object)"bar");
                });
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        });
    }

    @Test
    public void testWatchWithDeletion() {
        AtomicBoolean done = new AtomicBoolean();
        ServiceDiscovery discovery = ServiceDiscovery.create((Vertx)this.vertx, (ServiceDiscoveryOptions)new ServiceDiscoveryOptions());
        discovery.registerServiceImporter((ServiceImporter)new KubernetesServiceImporter(), this.config().copy().put("namespace", (Object)"issue96"), ar -> done.set(ar.succeeded()));
        Awaitility.await().untilAtomic(done, Is.is((Object)true));
        Awaitility.await().until(() -> {
            List<Record> records = this.getRecordsBlocking(discovery);
            try {
                this.assertThatListDoesNotContain(records, "hello-minikube");
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        });
    }

    private void assertThatListContains(List<Record> records, String name) {
        for (Record rec : records) {
            if (!rec.getName().equalsIgnoreCase(name)) continue;
            return;
        }
        throw new AssertionError((Object)("Cannot find service '" + name + "' in the list"));
    }

    private void assertThatListDoesNotContain(List<Record> records, String name) {
        for (Record rec : records) {
            if (rec.getName().equalsIgnoreCase(name)) {
                throw new AssertionError((Object)("Found service '" + name + "' in the list"));
            }
        }
    }

    private KubernetesResource getUpdatedHttpService() {
        Service service = this.getHttpService();
        return this.addLabelFooBar(service);
    }

    private Service addLabelFooBar(Service service) {
        HashMap<String, String> labels = service.getMetadata().getLabels();
        if (labels == null) {
            labels = new HashMap<String, String>();
            service.getMetadata().setLabels(labels);
        }
        labels.put("foo", "bar");
        return service;
    }

    private List<Record> getRecordsBlocking(ServiceDiscovery discovery) {
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Record> records = new ArrayList<Record>();
        discovery.getRecords(s -> true, ar -> {
            records.addAll((Collection)ar.result());
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return records;
    }

    private Service getSimpleService(String uid, String name) {
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName(name);
        metadata.setUid(uid);
        metadata.setNamespace("my-project");
        ServiceSpec spec = new ServiceSpec();
        ServicePort port = new ServicePort();
        port.setTargetPort(new IntOrString(Integer.valueOf(8080)));
        port.setPort(Integer.valueOf(1524));
        spec.setPorts(Collections.singletonList(port));
        Service service = new Service();
        service.setMetadata(metadata);
        service.setSpec(spec);
        return service;
    }

    private Service getHttpService() {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put("service-type", "http-endpoint");
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName("my-http-service");
        metadata.setUid("uuid-1");
        metadata.setNamespace("my-project");
        metadata.setLabels(labels);
        ServiceSpec spec = new ServiceSpec();
        ServicePort port = new ServicePort();
        port.setTargetPort(new IntOrString(Integer.valueOf(80)));
        port.setPort(Integer.valueOf(8080));
        spec.setPorts(Collections.singletonList(port));
        Service service = new Service();
        service.setMetadata(metadata);
        service.setSpec(spec);
        return service;
    }

    private Service getService96() {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put("service-type", "http-endpoint");
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName("hello-minikube");
        metadata.setUid("37c57c1e-deb0-11e8-a8ee-0800274f8294");
        metadata.setNamespace("issue96");
        metadata.setLabels(labels);
        metadata.getAdditionalProperties().put("run", "hello-minikube");
        ServiceSpec spec = new ServiceSpec();
        ServicePort port = new ServicePort();
        port.setTargetPort(new IntOrString(Integer.valueOf(80)));
        port.setPort(Integer.valueOf(8080));
        spec.setPorts(Collections.singletonList(port));
        Service service = new Service();
        service.setMetadata(metadata);
        service.setSpec(spec);
        return service;
    }

    private Service getUpdatedService96() {
        return this.getService96();
    }
}

