/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.kubernetes;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.kubernetes.KubernetesServiceImporter;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class KubernetesServiceImporterTest {
    private static final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testRecordCreation() throws Exception {
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName("my-service");
        metadata.setUid("uuid");
        metadata.setNamespace("my-project");
        ServiceSpec spec = new ServiceSpec();
        ServicePort port = new ServicePort();
        port.setTargetPort(new IntOrString(Integer.valueOf(8080)));
        port.setPort(Integer.valueOf(1524));
        spec.setPorts(Collections.singletonList(port));
        Service service = new Service();
        service.setMetadata(metadata);
        service.setSpec(spec);
        Record record = KubernetesServiceImporter.createRecord((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)));
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((String)record.getName()).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.name")).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.namespace")).isEqualTo((Object)"my-project");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.uuid")).isEqualTo((Object)"uuid");
        Assertions.assertThat((String)record.getType()).isEqualTo((Object)"unknown");
        Assertions.assertThat((Integer)record.getLocation().getInteger("port")).isEqualTo(1524);
    }

    @Test
    public void testHttpRecordCreation() throws Exception {
        Service service = this.getHttpService();
        Record record = KubernetesServiceImporter.createRecord((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)));
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((String)record.getName()).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.name")).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.namespace")).isEqualTo((Object)"my-project");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.uuid")).isEqualTo((Object)"uuid");
        Assertions.assertThat((String)record.getType()).isEqualTo((Object)"http-endpoint");
        Assertions.assertThat((Integer)record.getLocation().getInteger("port")).isEqualTo(8080);
        Assertions.assertThat((Boolean)record.getLocation().getBoolean("ssl")).isFalse();
    }

    private Service getHttpService() {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put("service-type", "http-endpoint");
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName("my-service");
        metadata.setUid("uuid");
        metadata.setNamespace("my-project");
        metadata.setLabels(labels);
        ServiceSpec spec = new ServiceSpec();
        ServicePort port = new ServicePort();
        port.setTargetPort(new IntOrString(Integer.valueOf(80)));
        port.setPort(Integer.valueOf(8080));
        spec.setPorts(Collections.singletonList(port));
        Service service = new Service();
        service.setMetadata(metadata);
        service.setSpec(spec);
        return service;
    }

    @Test
    public void testHttpWithSSLRecordCreation() throws Exception {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put("service-type", "http-endpoint");
        labels.put("ssl", "true");
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName("my-service");
        metadata.setUid("uuid");
        metadata.setNamespace("my-project");
        metadata.setLabels(labels);
        ServiceSpec spec = new ServiceSpec();
        ServicePort port = new ServicePort();
        port.setTargetPort(new IntOrString(Integer.valueOf(8080)));
        port.setPort(Integer.valueOf(8080));
        spec.setPorts(Collections.singletonList(port));
        Service service = new Service();
        service.setMetadata(metadata);
        service.setSpec(spec);
        Record record = KubernetesServiceImporter.createRecord((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)));
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((String)record.getName()).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.name")).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.namespace")).isEqualTo((Object)"my-project");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.uuid")).isEqualTo((Object)"uuid");
        Assertions.assertThat((String)record.getType()).isEqualTo((Object)"http-endpoint");
        Assertions.assertThat((Integer)record.getLocation().getInteger("port")).isEqualTo(8080);
        Assertions.assertThat((Boolean)record.getLocation().getBoolean("ssl")).isTrue();
    }

    @Test
    public void testServiceTypeDetection() throws Exception {
        LinkedHashMap labels = new LinkedHashMap();
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName("my-service");
        metadata.setUid("uuid");
        metadata.setNamespace("my-project");
        metadata.setLabels(labels);
        ServiceSpec spec = new ServiceSpec();
        ServicePort port = new ServicePort();
        port.setTargetPort(new IntOrString(Integer.valueOf(8080)));
        port.setPort(Integer.valueOf(8080));
        spec.setPorts(Collections.singletonList(port));
        Service service = new Service();
        service.setMetadata(metadata);
        service.setSpec(spec);
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"http-endpoint");
        port.setPort(Integer.valueOf(443));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"http-endpoint");
        port.setPort(Integer.valueOf(433));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"unknown");
        port.setPort(Integer.valueOf(8888));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"http-endpoint");
        port.setPort(Integer.valueOf(8080));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"http-endpoint");
        port.setPort(Integer.valueOf(9000));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"http-endpoint");
        port.setPort(Integer.valueOf(80));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"http-endpoint");
        port.setPort(Integer.valueOf(6379));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"redis");
        port.setPort(Integer.valueOf(3306));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"jdbc");
        port.setPort(Integer.valueOf(27017));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"mongo");
        port.setPort(Integer.valueOf(27018));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"mongo");
        port.setPort(Integer.valueOf(27019));
        Assertions.assertThat((String)KubernetesServiceImporter.discoveryType((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)), (Record)new Record())).isEqualTo((Object)"mongo");
    }

    @Test
    public void testHttpExternalServiceRecordCreation() throws Exception {
        int servicePort = 8080;
        Service service = this.getExternalService(servicePort);
        Record record = KubernetesServiceImporter.createRecord((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)));
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((String)record.getName()).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.name")).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.namespace")).isEqualTo((Object)"my-project");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.uuid")).isEqualTo((Object)"uuid");
        Assertions.assertThat((String)record.getType()).isEqualTo((Object)"http-endpoint");
        Assertions.assertThat((String)record.getLocation().getString("host")).isEqualTo((Object)"my-external-service");
        Assertions.assertThat((Integer)record.getLocation().getInteger("port")).isEqualTo(servicePort);
        Assertions.assertThat((Boolean)record.getLocation().getBoolean("ssl")).isFalse();
        Assertions.assertThat((String)record.getLocation().getString("endpoint")).isEqualTo((Object)("http://my-external-service:" + servicePort));
    }

    @Test
    public void testHttpWithSSLExternalServiceRecordCreation() throws Exception {
        int servicePort = 443;
        Service service = this.getExternalService(servicePort);
        Record record = KubernetesServiceImporter.createRecord((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)));
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((String)record.getName()).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.name")).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.namespace")).isEqualTo((Object)"my-project");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.uuid")).isEqualTo((Object)"uuid");
        Assertions.assertThat((String)record.getType()).isEqualTo((Object)"http-endpoint");
        Assertions.assertThat((String)record.getLocation().getString("host")).isEqualTo((Object)"my-external-service");
        Assertions.assertThat((Integer)record.getLocation().getInteger("port")).isEqualTo(servicePort);
        Assertions.assertThat((Boolean)record.getLocation().getBoolean("ssl")).isTrue();
        Assertions.assertThat((String)record.getLocation().getString("endpoint")).isEqualTo((Object)("https://my-external-service:" + servicePort));
    }

    @Test
    public void testUnknownExternalServiceRecordCreation() throws Exception {
        int servicePort = 5432;
        Service service = this.getExternalService(servicePort);
        Record record = KubernetesServiceImporter.createRecord((JsonObject)new JsonObject(mapper.writeValueAsString((Object)service)));
        Assertions.assertThat((Object)record).isNotNull();
        Assertions.assertThat((String)record.getName()).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.name")).isEqualTo((Object)"my-service");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.namespace")).isEqualTo((Object)"my-project");
        Assertions.assertThat((String)record.getMetadata().getString("kubernetes.uuid")).isEqualTo((Object)"uuid");
        Assertions.assertThat((String)record.getType()).isEqualTo((Object)"jdbc");
        Assertions.assertThat((String)record.getLocation().getString("host")).isEqualTo((Object)"my-external-service");
        Assertions.assertThat((Integer)record.getLocation().getInteger("port")).isEqualTo(servicePort);
    }

    private Service getExternalService(int port) {
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName("my-service");
        metadata.setUid("uuid");
        metadata.setNamespace("my-project");
        ServiceSpec serviceSpec = new ServiceSpec();
        ServicePort servicePort = new ServicePort();
        servicePort.setPort(Integer.valueOf(port));
        serviceSpec.setType("ExternalName");
        serviceSpec.setExternalName("my-external-service");
        serviceSpec.setPorts(Collections.singletonList(servicePort));
        Service service = new Service();
        service.setMetadata(metadata);
        service.setSpec(serviceSpec);
        return service;
    }
}

