/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HelperUtils {
    public static <T> Handler<AsyncResult<T>> createHandler(Message msg, boolean includeDebugInfo) {
        return res -> {
            if (res.failed()) {
                HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
            } else if (res.result() != null && res.result().getClass().isEnum()) {
                msg.reply((Object)((Enum)res.result()).name());
            } else {
                msg.reply(res.result());
            }
        };
    }

    public static <T> Handler<AsyncResult<List<T>>> createListHandler(Message msg, boolean includeDebugInfo) {
        return res -> {
            if (res.failed()) {
                HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
            } else {
                msg.reply((Object)new JsonArray((List)res.result()));
            }
        };
    }

    public static <T> Handler<AsyncResult<Set<T>>> createSetHandler(Message msg, boolean includeDebugInfo) {
        return res -> {
            if (res.failed()) {
                HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
            } else {
                msg.reply((Object)new JsonArray(new ArrayList((Collection)res.result())));
            }
        };
    }

    public static <T> Handler<AsyncResult<Map<String, T>>> createMapHandler(Message msg, boolean includeDebugInfo) {
        return res -> {
            if (res.failed()) {
                HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
            } else {
                msg.reply((Object)new JsonObject(new HashMap((Map)res.result())));
            }
        };
    }

    public static Handler<AsyncResult<List<Character>>> createListCharHandler(Message msg, boolean includeDebugInfo) {
        return res -> {
            if (res.failed()) {
                HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (List)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    public static Handler<AsyncResult<Set<Character>>> createSetCharHandler(Message msg, boolean includeDebugInfo) {
        return res -> {
            if (res.failed()) {
                HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (Set)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    public static Handler<AsyncResult<Map<String, Character>>> createMapCharHandler(Message msg, boolean includeDebugInfo) {
        return res -> {
            if (res.failed()) {
                HelperUtils.manageFailure(msg, res.cause(), includeDebugInfo);
            } else {
                JsonObject obj = new JsonObject();
                for (Map.Entry chr : ((Map)res.result()).entrySet()) {
                    obj.put((String)chr.getKey(), Integer.valueOf(((Character)chr.getValue()).charValue()));
                }
                msg.reply((Object)obj);
            }
        };
    }

    public static void manageFailure(Message msg, Throwable cause, boolean includeDebugInfo) {
        if (cause instanceof ServiceException) {
            msg.reply((Object)cause);
        } else if (includeDebugInfo) {
            msg.reply((Object)new ServiceException(-1, cause.getMessage(), HelperUtils.generateDebugInfo(cause)));
        } else {
            msg.reply((Object)new ServiceException(-1, cause.getMessage()));
        }
    }

    public static <T> Map<String, T> convertMap(Map map) {
        return map;
    }

    public static <T> List<T> convertList(List list) {
        return list;
    }

    public static <T> Set<T> convertSet(List list) {
        return new HashSet(list);
    }

    public static JsonObject generateDebugInfo(Throwable cause) {
        if (cause == null) {
            return null;
        }
        JsonObject obj = new JsonObject();
        obj.put("causeName", cause.getClass().getCanonicalName());
        obj.put("causeMessage", cause.getMessage());
        obj.put("causeStackTrace", HelperUtils.convertStackTrace(cause));
        return obj;
    }

    public static JsonArray convertStackTrace(Throwable cause) {
        if (cause == null || cause.getStackTrace() == null) {
            return new JsonArray();
        }
        return Arrays.stream(cause.getStackTrace()).map(StackTraceElement::toString).collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
    }
}

