/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.generator.model;

import io.vertx.codegen.ClassModel;
import io.vertx.codegen.GenException;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.MethodKind;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.annotations.ProxyClose;
import io.vertx.codegen.annotations.ProxyIgnore;
import io.vertx.codegen.doc.Doc;
import io.vertx.codegen.doc.Text;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.DataObjectTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeMirrorFactory;
import io.vertx.serviceproxy.generator.model.ProxyMethodInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ProxyModel
extends ClassModel {
    public ProxyModel(ProcessingEnvironment env, TypeMirrorFactory typeFactory, TypeElement modelElt) {
        super(env, typeFactory, modelElt);
    }

    public String getKind() {
        return "proxy";
    }

    protected void checkParamType(ExecutableElement elem, TypeInfo typeInfo, int pos, int numParams, boolean allowAnyJavaType) {
        if (typeInfo.getKind().basic || typeInfo.getKind().json) {
            return;
        }
        if (typeInfo.getKind() == ClassKind.ENUM) {
            return;
        }
        if (this.isLegalContainerParam(typeInfo)) {
            return;
        }
        if (typeInfo.getKind() == ClassKind.DATA_OBJECT) {
            if (((DataObjectTypeInfo)typeInfo).isSerializable() && ((DataObjectTypeInfo)typeInfo).isDeserializable()) {
                return;
            }
            throw new GenException((Element)elem, "Data Object " + typeInfo + " must have a valid serializer and deserializer");
        }
        if (this.isLegalHandlerAsyncResultType(typeInfo)) {
            if (pos != numParams - 1) {
                throw new GenException((Element)elem, "Handler<AsyncResult<T>> must be the last parameter if present in a proxied method");
            }
            return;
        }
        if (elem.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        throw new GenException((Element)elem, "type " + typeInfo + " is not legal for use for a parameter in proxy");
    }

    protected void checkReturnType(ExecutableElement elem, TypeInfo type, boolean allowAnyJavaType) {
        if (elem.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        if (type.isVoid()) {
            return;
        }
        throw new GenException((Element)elem, "Proxy methods must have void or Fluent returns");
    }

    protected void checkMethod(MethodInfo methodInfo) {
        List methodsByName = (List)this.methodMap.get(methodInfo.getName());
        if (methodsByName != null && methodsByName.size() > 1) {
            throw new GenException((Element)this.modelElt, "Overloaded methods are not allowed in ProxyGen interfaces " + methodInfo.getName());
        }
    }

    protected MethodInfo createMethodInfo(Set<ClassTypeInfo> ownerTypes, String methodName, String comment, Doc doc, TypeInfo returnType, Text returnDescription, boolean isFluent, boolean isCacheReturn, List<ParamInfo> mParams, ExecutableElement methodElt, boolean isStatic, boolean isDefault, ArrayList<TypeParamInfo.Method> typeParams, TypeElement declaringElt, boolean methodDeprecated, Text methodDeprecatedDesc) {
        AnnotationMirror proxyIgnoreAnnotation = Helper.resolveMethodAnnotation(ProxyIgnore.class, (Elements)this.elementUtils, (Types)this.typeUtils, (TypeElement)declaringElt, (ExecutableElement)methodElt);
        boolean isProxyIgnore = proxyIgnoreAnnotation != null;
        AnnotationMirror proxyCloseAnnotation = Helper.resolveMethodAnnotation(ProxyClose.class, (Elements)this.elementUtils, (Types)this.typeUtils, (TypeElement)declaringElt, (ExecutableElement)methodElt);
        boolean isProxyClose = proxyCloseAnnotation != null;
        ProxyMethodInfo proxyMeth = new ProxyMethodInfo(ownerTypes, methodName, returnType, returnDescription, isFluent, isCacheReturn, mParams, comment, doc, isStatic, isDefault, typeParams, isProxyIgnore, isProxyClose, methodDeprecated, methodDeprecatedDesc);
        if (isProxyClose && mParams.size() > 0) {
            if (mParams.size() > 1) {
                throw new GenException((Element)this.modelElt, "@ProxyClose methods can't have more than one parameter");
            }
            if (proxyMeth.getKind() != MethodKind.FUTURE) {
                throw new GenException((Element)this.modelElt, "@ProxyClose parameter must be Handler<AsyncResult<Void>>");
            }
            TypeInfo type = mParams.get(0).getType();
            TypeInfo arg = (TypeInfo)((ParameterizedTypeInfo)((ParameterizedTypeInfo)type).getArgs().get(0)).getArgs().get(0);
            if (arg.getKind() != ClassKind.VOID) {
                throw new GenException((Element)this.modelElt, "@ProxyClose parameter must be Handler<AsyncResult<Void>> instead of " + type);
            }
        }
        return proxyMeth;
    }

    private boolean isLegalHandlerAsyncResultType(TypeInfo type) {
        TypeInfo eventType;
        if (type.getErased().getKind() == ClassKind.HANDLER && (eventType = (TypeInfo)((ParameterizedTypeInfo)type).getArgs().get(0)).getErased().getKind() == ClassKind.ASYNC_RESULT) {
            ApiTypeInfo cla;
            TypeInfo resultType = (TypeInfo)((ParameterizedTypeInfo)eventType).getArgs().get(0);
            if (resultType.getKind().json || resultType.getKind().basic || this.isLegalContainerParam(resultType) || resultType.getKind() == ClassKind.VOID || resultType.getKind() == ClassKind.ENUM || resultType.getKind() == ClassKind.DATA_OBJECT) {
                return true;
            }
            if (resultType.getKind() == ClassKind.API && (cla = (ApiTypeInfo)resultType).isProxyGen()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isLegalContainerParam(TypeInfo type) {
        ClassTypeInfo raw = type.getRaw();
        if (raw.getName().equals(List.class.getName()) || raw.getName().equals(Set.class.getName())) {
            TypeInfo argument = (TypeInfo)((ParameterizedTypeInfo)type).getArgs().get(0);
            if (argument.getKind().basic || argument.getKind().json || this.isValidDataObject(argument)) {
                return true;
            }
        } else if (raw.getName().equals(Map.class.getName())) {
            TypeInfo argument0 = (TypeInfo)((ParameterizedTypeInfo)type).getArgs().get(0);
            if (!argument0.getName().equals(String.class.getName())) {
                return false;
            }
            TypeInfo argument1 = (TypeInfo)((ParameterizedTypeInfo)type).getArgs().get(1);
            if (argument1.getKind().basic || argument1.getKind().json || this.isValidDataObject(argument1)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidDataObject(TypeInfo typeInfo) {
        return typeInfo.getKind() == ClassKind.DATA_OBJECT && ((DataObjectTypeInfo)typeInfo).isSerializable() && ((DataObjectTypeInfo)typeInfo).isDeserializable();
    }
}

