/*
 * Decompiled with CFR 0.152.
 */
package rx.lang.groovy;

import groovy.lang.Closure;
import groovy.lang.MetaMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.m12n.ExtensionModule;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action;
import rx.functions.Function;
import rx.lang.groovy.GroovyActionWrapper;
import rx.lang.groovy.GroovyCreateWrapper;
import rx.lang.groovy.GroovyFunctionWrapper;
import rx.lang.groovy.GroovyOnSubscribeWrapper;
import rx.observables.BlockingObservable;

public class RxGroovyExtensionModule
extends ExtensionModule {
    private static final Class[] CLASS_TO_EXTEND = new Class[]{Observable.class, BlockingObservable.class};

    public RxGroovyExtensionModule() {
        super("RxGroovyExtensionModule", "1.0");
    }

    public List<MetaMethod> getMetaMethods() {
        ArrayList<MetaMethod> methods = new ArrayList<MetaMethod>();
        for (Class classToExtend : CLASS_TO_EXTEND) {
            ArrayList<Method> funcMethods = new ArrayList<Method>();
            ArrayList<String> names = new ArrayList<String>();
            block1: for (Method m : classToExtend.getMethods()) {
                for (Class<?> c : m.getParameterTypes()) {
                    if (!Function.class.isAssignableFrom(c)) continue;
                    funcMethods.add(m);
                    names.add(m.getName());
                    continue block1;
                }
            }
            CallSiteArray callSites = new CallSiteArray(classToExtend, names.toArray(new String[0]));
            for (int index = 0; index < funcMethods.size(); ++index) {
                methods.add(this.createMetaMethod((Method)funcMethods.get(index), callSites, index));
            }
        }
        return methods;
    }

    private MetaMethod createMetaMethod(final Method m, final CallSiteArray callSites, final int callSiteIndex) {
        if (m.getDeclaringClass().equals(Observable.class) && m.getName().equals("create")) {
            return this.specialCasedOverrideForCreate(m);
        }
        return new MetaMethod(){

            public int getModifiers() {
                return m.getModifiers();
            }

            public String getName() {
                return m.getName();
            }

            public Class getReturnType() {
                return m.getReturnType();
            }

            public CachedClass getDeclaringClass() {
                return ReflectionCache.getCachedClass(m.getDeclaringClass());
            }

            public Object invoke(Object object, Object[] arguments) {
                try {
                    Object[] newArgs = new Object[arguments.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        Object o = arguments[i];
                        if (o instanceof Closure) {
                            if (Action.class.isAssignableFrom(m.getParameterTypes()[i])) {
                                newArgs[i] = new GroovyActionWrapper((Closure<Void>)((Closure)o));
                                continue;
                            }
                            if (Observable.OnSubscribe.class.isAssignableFrom(m.getParameterTypes()[i])) {
                                newArgs[i] = new GroovyOnSubscribeWrapper((Closure<Subscription>)((Closure)o));
                                continue;
                            }
                            newArgs[i] = new GroovyFunctionWrapper((Closure)o);
                            continue;
                        }
                        newArgs[i] = o;
                    }
                    return callSites.array[callSiteIndex].call(object, newArgs);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }

            public CachedClass[] getParameterTypes() {
                if (this.parameterTypes == null) {
                    this.getParametersTypes0();
                }
                return this.parameterTypes;
            }

            private synchronized void getParametersTypes0() {
                if (this.parameterTypes != null) {
                    return;
                }
                Class[] npt = this.nativeParamTypes == null ? this.getPT() : this.nativeParamTypes;
                CachedClass[] pt = new CachedClass[npt.length];
                for (int i = 0; i != npt.length; ++i) {
                    pt[i] = Function.class.isAssignableFrom(npt[i]) ? ReflectionCache.getCachedClass(Closure.class) : ReflectionCache.getCachedClass((Class)npt[i]);
                }
                this.nativeParamTypes = npt;
                this.setParametersTypes(pt);
            }

            protected Class[] getPT() {
                return m.getParameterTypes();
            }
        };
    }

    private MetaMethod specialCasedOverrideForCreate(final Method m) {
        return new MetaMethod(){

            public int getModifiers() {
                return m.getModifiers();
            }

            public String getName() {
                return m.getName();
            }

            public Class<?> getReturnType() {
                return m.getReturnType();
            }

            public CachedClass getDeclaringClass() {
                return ReflectionCache.getCachedClass(m.getDeclaringClass());
            }

            public Object invoke(Object object, Object[] arguments) {
                return Observable.create(new GroovyCreateWrapper((Closure<Void>)((Closure)arguments[0])));
            }

            public CachedClass[] getParameterTypes() {
                if (this.parameterTypes == null) {
                    this.getParametersTypes0();
                }
                return this.parameterTypes;
            }

            private synchronized void getParametersTypes0() {
                if (this.parameterTypes != null) {
                    return;
                }
                Class[] npt = this.nativeParamTypes == null ? this.getPT() : this.nativeParamTypes;
                CachedClass[] pt = new CachedClass[npt.length];
                for (int i = 0; i != npt.length; ++i) {
                    pt[i] = Function.class.isAssignableFrom(npt[i]) ? ReflectionCache.getCachedClass(Closure.class) : ReflectionCache.getCachedClass((Class)npt[i]);
                }
                this.nativeParamTypes = npt;
                this.setParametersTypes(pt);
            }

            protected Class[] getPT() {
                return m.getParameterTypes();
            }
        };
    }
}

