/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.docgen.BaseProcessor;
import io.vertx.docgen.Coordinate;
import io.vertx.docgen.DocGenerator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class DocGenProcessor
extends BaseProcessor {
    private List<DocGenerator> generators = new ArrayList<DocGenerator>();
    private DocGenerator current;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        ScriptEngineManager manager = new ScriptEngineManager();
        try {
            ArrayList<URL> docgenUrls = Collections.list(DocGenProcessor.class.getClassLoader().getResources("docgen.json"));
            for (URL docgenUrl : docgenUrls) {
                InputStream docgenIn = docgenUrl.openStream();
                Throwable throwable = null;
                try {
                    ScriptEngine engine = manager.getEngineByName("nashorn");
                    engine.put("processingEnv", processingEnv);
                    engine.put("typeUtils", processingEnv.getTypeUtils());
                    engine.put("elementUtils", processingEnv.getElementUtils());
                    ObjectMapper parser = new ObjectMapper();
                    JsonNode obj = parser.readTree(docgenIn);
                    String name = obj.get("name").asText();
                    String scripts = obj.get("scripts").asText();
                    try (InputStream scriptsIn = DocGenProcessor.class.getClassLoader().getResourceAsStream(scripts);){
                        engine.eval(new InputStreamReader(scriptsIn));
                    }
                    this.generators.add(new Generator(name, engine));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (docgenIn == null) continue;
                    if (throwable != null) {
                        try {
                            docgenIn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    docgenIn.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator<DocGenerator> it = ServiceLoader.load(DocGenerator.class, DocGenProcessor.class.getClassLoader()).iterator();
        while (it.hasNext()) {
            try {
                this.generators.add(it.next());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected String getName() {
        return this.current.getName();
    }

    @Override
    protected String resolveRelativeFileName(PackageElement docElt) {
        String relativeFileName = super.resolveRelativeFileName(docElt);
        relativeFileName = this.current.resolveRelativeFileName(docElt, relativeFileName);
        return relativeFileName;
    }

    @Override
    protected void handleGen(PackageElement docElt) {
        Iterator<DocGenerator> iterator = this.generators.iterator();
        while (iterator.hasNext()) {
            DocGenerator generator;
            this.current = generator = iterator.next();
            this.current.init(this.processingEnv);
            StringWriter buffer = new StringWriter();
            this.process(buffer, docElt);
            this.write(docElt, buffer.toString());
        }
    }

    @Override
    protected String renderSource(ExecutableElement elt, String source) {
        return this.current.renderSource(elt, source);
    }

    @Override
    protected String resolveTypeLink(TypeElement elt, Coordinate coordinate) {
        return this.current.resolveTypeLink(elt, coordinate);
    }

    @Override
    protected String resolveConstructorLink(ExecutableElement elt, Coordinate coordinate) {
        return this.current.resolveConstructorLink(elt, coordinate);
    }

    @Override
    protected String resolveMethodLink(ExecutableElement elt, Coordinate coordinate) {
        return this.current.resolveMethodLink(elt, coordinate);
    }

    @Override
    protected String resolveFieldLink(VariableElement elt, Coordinate coordinate) {
        return this.current.resolveFieldLink(elt, coordinate);
    }

    @Override
    protected String resolveLabel(Element elt) {
        String label = DocGenProcessor.super.resolveLabel(elt);
        return this.current.resolveLabel(elt, label);
    }

    class Generator
    implements DocGenerator {
        final String name;
        final ScriptEngine engine;

        public Generator(String name, ScriptEngine engine) {
            this.name = name;
            this.engine = engine;
        }

        private String eval(String functionName, Object ... args) {
            Thread currentThread = Thread.currentThread();
            ClassLoader prev = currentThread.getContextClassLoader();
            try {
                ScriptObjectMirror function = (ScriptObjectMirror)this.engine.eval(functionName);
                currentThread.setContextClassLoader(DocGenProcessor.class.getClassLoader());
                String string = (String)function.call((Object)DocGenProcessor.this, args);
                return string;
            }
            catch (ScriptException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                currentThread.setContextClassLoader(prev);
            }
        }

        @Override
        public void init(ProcessingEnvironment env) {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String renderSource(ExecutableElement elt, String source) {
            return this.eval("renderSource", elt, source);
        }

        @Override
        public String resolveTypeLink(TypeElement elt, Coordinate coordinate) {
            return this.eval("toTypeLink", elt, coordinate);
        }

        @Override
        public String resolveConstructorLink(ExecutableElement elt, Coordinate coordinate) {
            return this.eval("toConstructorLink", elt, coordinate);
        }

        @Override
        public String resolveMethodLink(ExecutableElement elt, Coordinate coordinate) {
            return this.eval("toMethodLink", elt, coordinate);
        }

        @Override
        public String resolveFieldLink(VariableElement elt, Coordinate coordinate) {
            return this.eval("toFieldLink", elt, coordinate);
        }

        @Override
        public String resolveLabel(Element elt, String defaultLabel) {
            String s = this.eval("resolveLabel", elt, defaultLabel);
            if (s != null) {
                defaultLabel = s;
            }
            return defaultLabel;
        }
    }
}

