/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.Handler;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.impl.Transactions;
import io.vertx.ext.stomp.utils.Headers;

public class DefaultAbortHandler
implements Handler<ServerFrame> {
    public void handle(ServerFrame sf) {
        String txId = sf.frame().getHeader("transaction");
        if (txId == null) {
            Frame error = Frames.createErrorFrame("Missing transaction id", Headers.create(), "ABORT frames must contain the 'transaction' header.");
            sf.connection().write(error).close();
            return;
        }
        if (!Transactions.instance().unregisterTransaction(sf.connection(), txId)) {
            Frame error = Frames.createErrorFrame("Unknown transaction", Headers.create("transaction", txId), "The transaction id is unknown.");
            sf.connection().write(error).close();
            return;
        }
        Frames.handleReceipt(sf.frame(), sf.connection());
    }
}

