/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Shareable;
import io.vertx.ext.stomp.BridgeOptions;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.StompServerConnection;
import io.vertx.ext.stomp.impl.EventBusBridge;
import io.vertx.ext.stomp.impl.Queue;
import io.vertx.ext.stomp.impl.Topic;
import java.util.List;

@VertxGen
public interface Destination
extends Shareable {
    public static Destination topic(Vertx vertx, String destination) {
        return new Topic(vertx, destination);
    }

    public static Destination queue(Vertx vertx, String destination) {
        return new Queue(vertx, destination);
    }

    public static Destination bridge(Vertx vertx, BridgeOptions options) {
        return new EventBusBridge(vertx, options);
    }

    public String destination();

    @Fluent
    public Destination dispatch(StompServerConnection var1, Frame var2);

    @Fluent
    public Destination subscribe(StompServerConnection var1, Frame var2);

    public boolean unsubscribe(StompServerConnection var1, Frame var2);

    @Fluent
    public Destination unsubscribeConnection(StompServerConnection var1);

    public boolean ack(StompServerConnection var1, Frame var2);

    public boolean nack(StompServerConnection var1, Frame var2);

    public List<String> getSubscriptions(StompServerConnection var1);

    public int numberOfSubscriptions();

    public boolean matches(String var1);
}

