/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.http.netty;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import io.termd.core.http.HttpTtyConnection;
import io.termd.core.util.Logging;
import java.io.InputStream;
import java.net.URL;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final String wsUri;

    public HttpRequestHandler(String wsUri) {
        this.wsUri = wsUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        if (this.wsUri.equalsIgnoreCase(request.getUri())) {
            ctx.fireChannelRead((Object)request.retain());
        } else {
            if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
                HttpRequestHandler.send100Continue(ctx);
            }
            DefaultHttpResponse response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR);
            String path = request.getUri();
            if ("/".equals(path)) {
                path = "/index.html";
            }
            URL res = HttpTtyConnection.class.getResource("/io/termd/core/http" + path);
            try {
                if (res != null) {
                    DefaultFullHttpResponse fullResp = new DefaultFullHttpResponse(request.getProtocolVersion(), HttpResponseStatus.OK);
                    InputStream in = res.openStream();
                    byte[] tmp = new byte[256];
                    int l = 0;
                    while (l != -1) {
                        fullResp.content().writeBytes(tmp, 0, l);
                        l = in.read(tmp);
                    }
                    int li = path.lastIndexOf(46);
                    if (li != -1 && li != path.length() - 1) {
                        String contentType;
                        String ext;
                        switch (ext = path.substring(li + 1, path.length())) {
                            case "html": {
                                contentType = "text/html";
                                break;
                            }
                            case "js": {
                                contentType = "application/javascript";
                                break;
                            }
                            default: {
                                contentType = null;
                            }
                        }
                        if (contentType != null) {
                            fullResp.headers().set("Content-Type", (Object)contentType);
                        }
                    }
                    response = fullResp;
                } else {
                    response.setStatus(HttpResponseStatus.NOT_FOUND);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ctx.write((Object)response);
                ChannelFuture future = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Logging.logReportedIoError(cause);
        ctx.close();
    }
}

