/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.readline;

import io.termd.core.readline.LineBuffer;
import io.termd.core.readline.LineStatus;
import io.termd.core.readline.Readline;
import io.termd.core.util.Helper;
import io.termd.core.util.Vector;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Completion {
    private AtomicBoolean done = new AtomicBoolean();
    private final Readline.Interaction interaction;
    private final int[] line;
    private final int[] prefix;

    public static int[] findLongestCommonPrefix(List<int[]> entries) {
        return Helper.findLongestCommonPrefix(entries);
    }

    public Completion(Readline.Interaction interaction) {
        for (int index = interaction.buffer().getCursor(); index > 0 && interaction.buffer().getAt(index - 1) != 32; --index) {
        }
        LineBuffer prefix = interaction.line().copy();
        for (int i = index; i < interaction.buffer().getCursor(); ++i) {
            prefix.insert(interaction.buffer().getAt(i));
        }
        this.interaction = interaction;
        this.prefix = prefix.toArray();
        this.line = interaction.line().copy().insert(interaction.buffer().toArray()).toArray();
    }

    public int[] line() {
        return this.line;
    }

    public int[] prefix() {
        return this.prefix;
    }

    public Vector size() {
        return this.interaction.size();
    }

    public void complete(int[] text, boolean terminal) {
        if (!this.done.compareAndSet(false, true)) {
            throw new IllegalStateException();
        }
        if (text.length > 0 || terminal) {
            LineBuffer work = this.interaction.buffer().copy();
            LineStatus.Ext toto = work.insertEscaped(text);
            if (terminal) {
                switch (toto.getQuote()) {
                    case 34: {
                        if (toto.isEscaping()) break;
                        work.insert(34, 32);
                        toto.accept(34);
                        toto.accept(32);
                        break;
                    }
                    case 39: {
                        work.insert(39, 32);
                        toto.accept(39);
                        toto.accept(32);
                        break;
                    }
                    case 0: {
                        if (toto.isEscaping()) break;
                        work.insert(32);
                        toto.accept(32);
                    }
                }
            }
            this.interaction.refresh(work);
        }
        this.interaction.resume();
    }

    public void suggest(int[] text) {
        if (!this.done.compareAndSet(false, true)) {
            throw new IllegalStateException();
        }
        this.interaction.conn.write("\n");
        this.interaction.conn.stdoutHandler().accept(text);
        this.interaction.redraw();
        this.interaction.resume();
    }

    public void end() {
        this.complete(new int[0], false);
    }

    public void complete(int[] text) {
        this.complete(text, false);
    }

    public void suggest(List<int[]> candidates) {
        this.suggest(Helper.computeBlock(this.size(), candidates));
    }
}

