/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.ssh;

import io.termd.core.io.BinaryDecoder;
import io.termd.core.io.BinaryEncoder;
import io.termd.core.tty.TtyConnection;
import io.termd.core.tty.TtyEvent;
import io.termd.core.tty.TtyEventDecoder;
import io.termd.core.tty.TtyOutputMode;
import io.termd.core.util.Vector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.AsyncCommand;
import org.apache.sshd.server.ChannelSessionAware;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;

public class TtyCommand
implements AsyncCommand,
ChannelDataReceiver,
ChannelSessionAware {
    private static final Pattern LC_PATTERN = Pattern.compile("(?:\\p{Alpha}{2}_\\p{Alpha}{2}\\.)?([^@]+)(?:@.+)?");
    private final Consumer<TtyConnection> handler;
    private final Charset defaultCharset;
    private Charset charset;
    private String term;
    private TtyEventDecoder eventDecoder;
    private BinaryDecoder decoder;
    private Consumer<int[]> stdout;
    private Consumer<byte[]> out;
    private Vector size = null;
    private Consumer<Vector> sizeHandler;
    private Consumer<String> termHandler;
    private Consumer<Void> closeHandler;
    protected ChannelSession session;
    private final AtomicBoolean closed = new AtomicBoolean();
    private ExitCallback exitCallback;
    private Connection conn;
    private IoOutputStream ioOut;
    private long lastAccessedTime = System.currentTimeMillis();

    public TtyCommand(Charset defaultCharset, Consumer<TtyConnection> handler) {
        this.handler = handler;
        this.defaultCharset = defaultCharset;
    }

    public int data(ChannelSession channel, byte[] buf, int start, int len) throws IOException {
        if (this.decoder != null) {
            this.lastAccessedTime = System.currentTimeMillis();
            this.decoder.write(buf, start, len);
        }
        return len;
    }

    public void setChannelSession(ChannelSession session) {
        this.session = session;
    }

    public void setInputStream(InputStream in) {
    }

    public void setOutputStream(OutputStream out) {
    }

    public void setErrorStream(OutputStream err) {
    }

    public void setIoInputStream(IoInputStream in) {
    }

    public void setIoOutputStream(IoOutputStream out) {
        this.ioOut = out;
        this.out = bytes -> out.write((Buffer)new ByteArrayBuffer(bytes));
    }

    public void setIoErrorStream(IoOutputStream err) {
    }

    public void setExitCallback(ExitCallback callback) {
        this.exitCallback = callback;
    }

    public void start(Environment env) throws IOException {
        String lcctype = (String)env.getEnv().get("LC_CTYPE");
        if (lcctype != null) {
            this.charset = TtyCommand.parseCharset(lcctype);
        }
        if (this.charset == null) {
            this.charset = this.defaultCharset;
        }
        env.addSignalListener(signal -> this.updateSize(env), EnumSet.of(Signal.WINCH));
        this.updateSize(env);
        int vintr = this.getControlChar(env, PtyMode.VINTR, 3);
        int vsusp = this.getControlChar(env, PtyMode.VSUSP, 26);
        int veof = this.getControlChar(env, PtyMode.VEOF, 4);
        this.eventDecoder = new TtyEventDecoder(vintr, vsusp, veof);
        this.decoder = new BinaryDecoder(512, this.charset, this.eventDecoder);
        this.stdout = new TtyOutputMode(new BinaryEncoder(this.charset, this.out));
        this.term = (String)env.getEnv().get("TERM");
        this.conn = new Connection();
        this.session.setDataReceiver((ChannelDataReceiver)this);
        this.handler.accept(this.conn);
    }

    private int getControlChar(Environment env, PtyMode key, int def) {
        Integer controlChar = (Integer)env.getPtyModes().get(key);
        return controlChar != null ? controlChar : def;
    }

    public void updateSize(Environment env) {
        String columns = (String)env.getEnv().get("COLUMNS");
        String lines = (String)env.getEnv().get("LINES");
        if (lines != null && columns != null) {
            Vector size;
            try {
                int width = Integer.parseInt(columns);
                int height = Integer.parseInt(lines);
                size = new Vector(width, height);
            }
            catch (Exception ignore) {
                size = null;
            }
            if (size != null) {
                this.size = size;
                if (this.sizeHandler != null) {
                    this.sizeHandler.accept(size);
                }
            }
        }
    }

    public void close() throws IOException {
        this.ioOut.close(false).addListener(future -> {
            this.exitCallback.onExit(0);
            if (this.closed.compareAndSet(false, true) && this.closeHandler != null) {
                this.closeHandler.accept(null);
            }
        });
    }

    public void destroy() {
    }

    protected void execute(Runnable task) {
        this.session.getSession().getFactoryManager().getScheduledExecutorService().execute(task);
    }

    protected void schedule(Runnable task, long delay, TimeUnit unit) {
        this.session.getSession().getFactoryManager().getScheduledExecutorService().schedule(task, delay, unit);
    }

    private static Charset parseCharset(String value) {
        Matcher matcher = LC_PATTERN.matcher(value);
        if (matcher.matches()) {
            try {
                return Charset.forName(matcher.group(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private class Connection
    implements TtyConnection {
        private Connection() {
        }

        @Override
        public Charset inputCharset() {
            return TtyCommand.this.charset;
        }

        @Override
        public Charset outputCharset() {
            return TtyCommand.this.charset;
        }

        @Override
        public long lastAccessedTime() {
            return TtyCommand.this.lastAccessedTime;
        }

        @Override
        public String terminalType() {
            return TtyCommand.this.term;
        }

        @Override
        public Consumer<int[]> getStdinHandler() {
            return TtyCommand.this.eventDecoder.getReadHandler();
        }

        @Override
        public void setStdinHandler(Consumer<int[]> handler) {
            TtyCommand.this.eventDecoder.setReadHandler(handler);
        }

        @Override
        public Consumer<String> getTerminalTypeHandler() {
            return TtyCommand.this.termHandler;
        }

        @Override
        public void setTerminalTypeHandler(Consumer<String> handler) {
            TtyCommand.this.termHandler = handler;
        }

        @Override
        public Vector size() {
            return TtyCommand.this.size;
        }

        @Override
        public Consumer<Vector> getSizeHandler() {
            return TtyCommand.this.sizeHandler;
        }

        @Override
        public void setSizeHandler(Consumer<Vector> handler) {
            TtyCommand.this.sizeHandler = handler;
        }

        @Override
        public BiConsumer<TtyEvent, Integer> getEventHandler() {
            return TtyCommand.this.eventDecoder.getEventHandler();
        }

        @Override
        public void setEventHandler(BiConsumer<TtyEvent, Integer> handler) {
            TtyCommand.this.eventDecoder.setEventHandler(handler);
        }

        @Override
        public Consumer<int[]> stdoutHandler() {
            return TtyCommand.this.stdout;
        }

        @Override
        public void execute(Runnable task) {
            TtyCommand.this.execute(task);
        }

        @Override
        public void schedule(Runnable task, long delay, TimeUnit unit) {
            TtyCommand.this.schedule(task, delay, unit);
        }

        @Override
        public void setCloseHandler(Consumer<Void> handler) {
            TtyCommand.this.closeHandler = handler;
        }

        @Override
        public Consumer<Void> getCloseHandler() {
            return TtyCommand.this.closeHandler;
        }

        @Override
        public void close() {
            try {
                TtyCommand.this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

