/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.term;

import io.termd.core.term.Device;
import io.termd.core.term.Feature;
import io.termd.core.term.ParserHandler;
import io.termd.core.term.Sequence;
import io.termd.core.term.TermInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TermInfoBuilder
extends ParserHandler {
    private Entry entry;
    private final List<Entry> entries = new ArrayList<Entry>();

    @Override
    public void beginHeaderLine(String name) {
        this.entry = new Entry();
        this.entry.names.add(name);
    }

    @Override
    public void addHeader(String name) {
        this.entry.names.add(name);
    }

    @Override
    public void endHeaderLine() {
    }

    @Override
    public void addBooleanFeature(String name, boolean value) {
        this.entry.features.add(Feature.create(name, value));
    }

    @Override
    public void addStringFeature(String name, Sequence value) {
        if ("use".equals(name)) {
            this.entry.uses.add(value.toString());
        } else {
            this.entry.features.add(Feature.create(name, value));
        }
    }

    @Override
    public void addNumericFeature(String name, int value) {
        this.entry.features.add(Feature.create(name, value));
    }

    @Override
    public void endDevice() {
        this.entries.add(this.entry);
        this.entry = null;
    }

    @Override
    public void endDatabase() {
    }

    public TermInfo build() {
        HashMap<String, Entry> entryMap = new HashMap<String, Entry>();
        for (Entry entry : this.entries) {
            for (String alias : entry.names) {
                entryMap.put(alias, entry);
            }
        }
        LinkedHashMap<String, Device> devices = new LinkedHashMap<String, Device>();
        for (Entry entry : entryMap.values()) {
            Device resolved = this.resolve(entryMap, entry.names.get(0));
            devices.put(resolved.name, resolved);
            for (String synonym : resolved.synonyms) {
                devices.put(synonym, resolved);
            }
        }
        return new TermInfo(devices);
    }

    private Device resolve(Map<String, Entry> entryMap, String name) {
        Entry entry = entryMap.get(name);
        if (entry == null) {
            throw new IllegalStateException("Entry not found " + name);
        }
        if (entry.resolved != null) {
            return entry.resolved;
        }
        if (entry.resolving) {
            throw new IllegalStateException("Detected cycle in term info dependencies");
        }
        entry.resolving = true;
        Device result = new Device(entry.names);
        for (String use : entry.uses) {
            Device useEntry = this.resolve(entryMap, use);
            result.addFeatures(useEntry.getFeatures());
        }
        result.addFeatures(entry.features);
        entry.resolving = false;
        entry.resolved = result;
        return result;
    }

    static class Entry {
        final List<String> names = new ArrayList<String>();
        final List<Feature<?>> features = new ArrayList();
        final List<String> uses = new ArrayList<String>();
        boolean resolving;
        Device resolved;

        Entry() {
        }
    }
}

