/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.client.impl.client.AllPartitionsClientRequest;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;

abstract class AbstractCacheAllPartitionsRequest
extends AllPartitionsClientRequest {
    protected String name;

    protected AbstractCacheAllPartitionsRequest() {
    }

    protected AbstractCacheAllPartitionsRequest(String name) {
        this.name = name;
    }

    protected CacheOperationProvider getOperationProvider() {
        ICacheService service = (ICacheService)this.getService();
        CacheConfig cacheConfig = service.getCacheConfig(this.name);
        if (cacheConfig == null) {
            throw new CacheNotExistsException("Cache config for cache " + this.name + " has not been created yet !");
        }
        return service.getCacheOperationProvider(this.name, cacheConfig.getInMemoryFormat());
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }
}

