/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.exceptionconverters.ClientExceptionConverter;
import com.hazelcast.client.impl.exceptionconverters.ClientExceptionConverters;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.core.ClientType;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.EventService;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.xa.XATransactionContextImpl;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class ClientEndpointImpl
implements ClientEndpoint {
    private final ClientEngineImpl clientEngine;
    private final Connection conn;
    private final ConcurrentMap<String, TransactionContext> transactionContextMap = new ConcurrentHashMap<String, TransactionContext>();
    private final ConcurrentHashMap<String, Callable> removeListenerActions = new ConcurrentHashMap();
    private final SocketAddress socketAddress;
    private LoginContext loginContext;
    private ClientPrincipal principal;
    private boolean firstConnection;
    private Credentials credentials;
    private volatile boolean authenticated;

    public ClientEndpointImpl(ClientEngineImpl clientEngine, Connection conn) {
        this.clientEngine = clientEngine;
        this.conn = conn;
        if (conn instanceof TcpIpConnection) {
            TcpIpConnection tcpIpConnection = (TcpIpConnection)conn;
            this.socketAddress = tcpIpConnection.getSocketChannelWrapper().socket().getRemoteSocketAddress();
        } else {
            this.socketAddress = null;
        }
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public String getUuid() {
        return this.principal != null ? this.principal.getUuid() : null;
    }

    @Override
    public boolean isAlive() {
        return this.conn.isAlive();
    }

    @Override
    public void setLoginContext(LoginContext loginContext) {
        this.loginContext = loginContext;
    }

    @Override
    public Subject getSubject() {
        return this.loginContext != null ? this.loginContext.getSubject() : null;
    }

    @Override
    public boolean isFirstConnection() {
        return this.firstConnection;
    }

    @Override
    public void authenticated(ClientPrincipal principal, Credentials credentials, boolean firstConnection) {
        this.principal = principal;
        this.firstConnection = firstConnection;
        this.credentials = credentials;
        this.authenticated = true;
    }

    @Override
    public void authenticated(ClientPrincipal principal) {
        this.principal = principal;
        this.authenticated = true;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.socketAddress;
    }

    @Override
    public ClientType getClientType() {
        ClientType type;
        switch (this.conn.getType()) {
            case JAVA_CLIENT: {
                type = ClientType.JAVA;
                break;
            }
            case CSHARP_CLIENT: {
                type = ClientType.CSHARP;
                break;
            }
            case CPP_CLIENT: {
                type = ClientType.CPP;
                break;
            }
            case PYTHON_CLIENT: {
                type = ClientType.PYTHON;
                break;
            }
            case RUBY_CLIENT: {
                type = ClientType.RUBY;
                break;
            }
            case BINARY_CLIENT: {
                type = ClientType.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connection type: " + (Object)((Object)this.conn.getType()));
            }
        }
        return type;
    }

    @Override
    public TransactionContext getTransactionContext(String txnId) {
        TransactionContext transactionContext = (TransactionContext)this.transactionContextMap.get(txnId);
        if (transactionContext == null) {
            throw new TransactionException("No transaction context found for txnId:" + txnId);
        }
        return transactionContext;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContextMap.put(transactionContext.getTxnId(), transactionContext);
    }

    @Override
    public void removeTransactionContext(String txnId) {
        this.transactionContextMap.remove(txnId);
    }

    @Override
    public void addListenerDestroyAction(final String service, final String topic, final String id) {
        final EventService eventService = this.clientEngine.getEventService();
        this.addDestroyAction(id, new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return eventService.deregisterListener(service, topic, id);
            }
        });
    }

    @Override
    public void addDestroyAction(String registrationId, Callable<Boolean> removeAction) {
        this.removeListenerActions.put(registrationId, removeAction);
    }

    @Override
    public boolean removeDestroyAction(String id) {
        return this.removeListenerActions.remove(id) != null;
    }

    @Override
    public void clearAllListeners() {
        for (Callable removeAction : this.removeListenerActions.values()) {
            try {
                removeAction.call();
            }
            catch (Exception e) {
                this.getLogger().warning("Exception during remove listener action", e);
            }
        }
        this.removeListenerActions.clear();
    }

    public void destroy() throws LoginException {
        this.clearAllListeners();
        LoginContext lc = this.loginContext;
        if (lc != null) {
            lc.logout();
        }
        for (TransactionContext context : this.transactionContextMap.values()) {
            if (context instanceof XATransactionContextImpl) continue;
            try {
                context.rollbackTransaction();
            }
            catch (HazelcastInstanceNotActiveException e) {
                this.getLogger().finest(e);
            }
            catch (Exception e) {
                this.getLogger().warning(e);
            }
        }
        this.authenticated = false;
    }

    private ILogger getLogger() {
        return this.clientEngine.getLogger(this.getClass());
    }

    @Override
    public void sendResponse(Object response, long callId) {
        Object clientResponseObject;
        boolean isError = false;
        if (response instanceof Throwable) {
            isError = true;
            ClientExceptionConverter converter = ClientExceptionConverters.get(this.getClientType());
            clientResponseObject = converter.convert((Throwable)response);
        } else {
            clientResponseObject = response != null ? response : new HeapData();
        }
        this.clientEngine.sendResponse(this, null, clientResponseObject, callId, isError, false);
    }

    public void sendClientMessage(ClientMessage clientMessage) {
        Connection conn = this.getConnection();
        conn.write(clientMessage);
    }

    @Override
    public void sendEvent(Object key, Object event, long callId) {
        this.clientEngine.sendResponse(this, key, event, callId, false, true);
    }

    public String toString() {
        return "ClientEndpoint{conn=" + this.conn + ", principal='" + this.principal + '\'' + ", firstConnection=" + this.firstConnection + ", authenticated=" + this.authenticated + '}';
    }
}

