/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.impl.SerializableList;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;

public class GetDistributedObjectsRequest
extends ClientRequest {
    @Override
    public void process() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        ProxyService proxyService = (ProxyService)this.getService();
        Collection<DistributedObject> distributedObjects = proxyService.getAllDistributedObjects();
        ArrayList<Data> dataArrayList = new ArrayList<Data>(distributedObjects.size());
        for (DistributedObject distributedObject : distributedObjects) {
            DistributedObjectInfo distributedObjectInfo = new DistributedObjectInfo(distributedObject.getServiceName(), distributedObject.getName());
            Object data = this.serializationService.toData(distributedObjectInfo);
            dataArrayList.add((Data)data);
        }
        SerializableList collection = new SerializableList(dataArrayList);
        endpoint.sendResponse(collection, this.getCallId());
    }

    @Override
    public String getServiceName() {
        return "hz:core:proxyService";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getDistributedObjects";
    }
}

