/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue;

import com.hazelcast.collection.impl.queue.client.AddAllRequest;
import com.hazelcast.collection.impl.queue.client.AddListenerRequest;
import com.hazelcast.collection.impl.queue.client.ClearRequest;
import com.hazelcast.collection.impl.queue.client.CompareAndRemoveRequest;
import com.hazelcast.collection.impl.queue.client.ContainsRequest;
import com.hazelcast.collection.impl.queue.client.DrainRequest;
import com.hazelcast.collection.impl.queue.client.IsEmptyRequest;
import com.hazelcast.collection.impl.queue.client.IteratorRequest;
import com.hazelcast.collection.impl.queue.client.OfferRequest;
import com.hazelcast.collection.impl.queue.client.PeekRequest;
import com.hazelcast.collection.impl.queue.client.PollRequest;
import com.hazelcast.collection.impl.queue.client.RemainingCapacityRequest;
import com.hazelcast.collection.impl.queue.client.RemoveListenerRequest;
import com.hazelcast.collection.impl.queue.client.RemoveRequest;
import com.hazelcast.collection.impl.queue.client.SizeRequest;
import com.hazelcast.collection.impl.txnqueue.client.TxnOfferRequest;
import com.hazelcast.collection.impl.txnqueue.client.TxnPeekRequest;
import com.hazelcast.collection.impl.txnqueue.client.TxnPollRequest;
import com.hazelcast.collection.impl.txnqueue.client.TxnSizeRequest;
import com.hazelcast.internal.serialization.PortableHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import java.util.Collection;

public class QueuePortableHook
implements PortableHook {
    public static final int F_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.portable.queue", -11);
    public static final int OFFER = 1;
    public static final int SIZE = 2;
    public static final int REMOVE = 3;
    public static final int POLL = 4;
    public static final int PEEK = 5;
    public static final int ITERATOR = 6;
    public static final int DRAIN = 7;
    public static final int CONTAINS = 8;
    public static final int COMPARE_AND_REMOVE = 9;
    public static final int CLEAR = 10;
    public static final int ADD_ALL = 11;
    public static final int ADD_LISTENER = 12;
    public static final int REMAINING_CAPACITY = 13;
    public static final int TXN_OFFER = 14;
    public static final int TXN_POLL = 15;
    public static final int TXN_SIZE = 16;
    public static final int TXN_PEEK = 17;
    public static final int REMOVE_LISTENER = 18;
    public static final int IS_EMPTY = 19;

    @Override
    public int getFactoryId() {
        return F_ID;
    }

    @Override
    public PortableFactory createFactory() {
        return new PortableFactory(){

            @Override
            public Portable create(int classId) {
                switch (classId) {
                    case 1: {
                        return new OfferRequest();
                    }
                    case 2: {
                        return new SizeRequest();
                    }
                    case 3: {
                        return new RemoveRequest();
                    }
                    case 4: {
                        return new PollRequest();
                    }
                    case 5: {
                        return new PeekRequest();
                    }
                    case 6: {
                        return new IteratorRequest();
                    }
                    case 7: {
                        return new DrainRequest();
                    }
                    case 8: {
                        return new ContainsRequest();
                    }
                    case 9: {
                        return new CompareAndRemoveRequest();
                    }
                    case 10: {
                        return new ClearRequest();
                    }
                    case 11: {
                        return new AddAllRequest();
                    }
                    case 12: {
                        return new AddListenerRequest();
                    }
                    case 13: {
                        return new RemainingCapacityRequest();
                    }
                    case 14: {
                        return new TxnOfferRequest();
                    }
                    case 15: {
                        return new TxnPollRequest();
                    }
                    case 16: {
                        return new TxnSizeRequest();
                    }
                    case 17: {
                        return new TxnPeekRequest();
                    }
                    case 18: {
                        return new RemoveListenerRequest();
                    }
                    case 19: {
                        return new IsEmptyRequest();
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Collection<ClassDefinition> getBuiltinDefinitions() {
        return null;
    }
}

