/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomicreference;

import com.hazelcast.concurrent.atomicreference.AtomicReferenceService;
import com.hazelcast.concurrent.atomicreference.operations.AlterAndGetOperation;
import com.hazelcast.concurrent.atomicreference.operations.AlterOperation;
import com.hazelcast.concurrent.atomicreference.operations.ApplyOperation;
import com.hazelcast.concurrent.atomicreference.operations.CompareAndSetOperation;
import com.hazelcast.concurrent.atomicreference.operations.ContainsOperation;
import com.hazelcast.concurrent.atomicreference.operations.GetAndAlterOperation;
import com.hazelcast.concurrent.atomicreference.operations.GetAndSetOperation;
import com.hazelcast.concurrent.atomicreference.operations.GetOperation;
import com.hazelcast.concurrent.atomicreference.operations.IsNullOperation;
import com.hazelcast.concurrent.atomicreference.operations.SetAndGetOperation;
import com.hazelcast.concurrent.atomicreference.operations.SetOperation;
import com.hazelcast.core.AsyncAtomicReference;
import com.hazelcast.core.IFunction;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;

public class AtomicReferenceProxy<E>
extends AbstractDistributedObject<AtomicReferenceService>
implements AsyncAtomicReference<E> {
    private final String name;
    private final int partitionId;

    public AtomicReferenceProxy(String name, NodeEngine nodeEngine, AtomicReferenceService service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    private <E> InternalCompletableFuture<E> asyncInvoke(Operation operation, NodeEngine nodeEngine) {
        try {
            OperationService operationService = nodeEngine.getOperationService();
            return operationService.invokeOnPartition("hz:impl:atomicReferenceService", operation, this.partitionId);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void alter(IFunction<E, E> function) {
        this.asyncAlter((IFunction)function).getSafely();
    }

    public InternalCompletableFuture<Void> asyncAlter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, "function");
        NodeEngine nodeEngine = this.getNodeEngine();
        AlterOperation operation = new AlterOperation(this.name, nodeEngine.toData(function));
        return this.asyncInvoke(operation, nodeEngine);
    }

    @Override
    public E alterAndGet(IFunction<E, E> function) {
        return this.asyncAlterAndGet((IFunction)function).getSafely();
    }

    @Override
    public InternalCompletableFuture<E> asyncAlterAndGet(IFunction<E, E> function) {
        Preconditions.isNotNull(function, "function");
        NodeEngine nodeEngine = this.getNodeEngine();
        AlterAndGetOperation operation = new AlterAndGetOperation(this.name, nodeEngine.toData(function));
        return this.asyncInvoke(operation, nodeEngine);
    }

    @Override
    public E getAndAlter(IFunction<E, E> function) {
        return this.asyncGetAndAlter((IFunction)function).getSafely();
    }

    @Override
    public InternalCompletableFuture<E> asyncGetAndAlter(IFunction<E, E> function) {
        Preconditions.isNotNull(function, "function");
        NodeEngine nodeEngine = this.getNodeEngine();
        GetAndAlterOperation operation = new GetAndAlterOperation(this.name, nodeEngine.toData(function));
        return this.asyncInvoke(operation, nodeEngine);
    }

    @Override
    public <R> R apply(IFunction<E, R> function) {
        return (R)this.asyncApply((IFunction)function).getSafely();
    }

    @Override
    public <R> InternalCompletableFuture<R> asyncApply(IFunction<E, R> function) {
        Preconditions.isNotNull(function, "function");
        NodeEngine nodeEngine = this.getNodeEngine();
        ApplyOperation operation = new ApplyOperation(this.name, nodeEngine.toData(function));
        return this.asyncInvoke(operation, nodeEngine);
    }

    @Override
    public void clear() {
        this.asyncClear().getSafely();
    }

    public InternalCompletableFuture<Void> asyncClear() {
        return this.asyncSet((Object)null);
    }

    @Override
    public boolean compareAndSet(E expect, E update) {
        return (Boolean)this.asyncCompareAndSet((Object)expect, (Object)update).getSafely();
    }

    public InternalCompletableFuture<Boolean> asyncCompareAndSet(E expect, E update) {
        NodeEngine nodeEngine = this.getNodeEngine();
        CompareAndSetOperation operation = new CompareAndSetOperation(this.name, nodeEngine.toData(expect), nodeEngine.toData(update));
        return this.asyncInvoke(operation, nodeEngine);
    }

    @Override
    public E get() {
        return this.asyncGet().getSafely();
    }

    @Override
    public InternalCompletableFuture<E> asyncGet() {
        GetOperation operation = new GetOperation(this.name);
        return this.asyncInvoke(operation, this.getNodeEngine());
    }

    @Override
    public boolean contains(E expected) {
        return (Boolean)this.asyncContains((Object)expected).getSafely();
    }

    public InternalCompletableFuture<Boolean> asyncContains(E value) {
        NodeEngine nodeEngine = this.getNodeEngine();
        ContainsOperation operation = new ContainsOperation(this.name, nodeEngine.toData(value));
        return this.asyncInvoke(operation, nodeEngine);
    }

    @Override
    public void set(E newValue) {
        this.asyncSet((Object)newValue).getSafely();
    }

    public InternalCompletableFuture<Void> asyncSet(E newValue) {
        NodeEngine nodeEngine = this.getNodeEngine();
        SetOperation operation = new SetOperation(this.name, nodeEngine.toData(newValue));
        return this.asyncInvoke(operation, nodeEngine);
    }

    @Override
    public E getAndSet(E newValue) {
        return this.asyncGetAndSet((Object)newValue).getSafely();
    }

    @Override
    public InternalCompletableFuture<E> asyncGetAndSet(E newValue) {
        NodeEngine nodeEngine = this.getNodeEngine();
        GetAndSetOperation operation = new GetAndSetOperation(this.name, nodeEngine.toData(newValue));
        return this.asyncInvoke(operation, nodeEngine);
    }

    @Override
    public E setAndGet(E update) {
        return this.asyncSetAndGet((Object)update).getSafely();
    }

    @Override
    public InternalCompletableFuture<E> asyncSetAndGet(E update) {
        NodeEngine nodeEngine = this.getNodeEngine();
        SetAndGetOperation operation = new SetAndGetOperation(this.name, nodeEngine.toData(update));
        return this.asyncInvoke(operation, nodeEngine);
    }

    @Override
    public boolean isNull() {
        return (Boolean)this.asyncIsNull().getSafely();
    }

    public InternalCompletableFuture<Boolean> asyncIsNull() {
        IsNullOperation operation = new IsNullOperation(this.name);
        return this.asyncInvoke(operation, this.getNodeEngine());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicReferenceService";
    }

    @Override
    public String toString() {
        return "IAtomicReference{name='" + this.name + '\'' + '}';
    }
}

