/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class ConditionInfo
implements DataSerializable {
    private String conditionId;
    private Map<ConditionWaiter, ConditionWaiter> waiters = new HashMap<ConditionWaiter, ConditionWaiter>(2);

    public ConditionInfo() {
    }

    public ConditionInfo(String conditionId) {
        this.conditionId = conditionId;
    }

    public boolean addWaiter(String caller, long threadId) {
        ConditionWaiter waiter = new ConditionWaiter(caller, threadId);
        return this.waiters.put(waiter, waiter) == null;
    }

    public boolean removeWaiter(String caller, long threadId) {
        ConditionWaiter waiter = new ConditionWaiter(caller, threadId);
        return this.waiters.remove(waiter) != null;
    }

    public String getConditionId() {
        return this.conditionId;
    }

    public int getAwaitCount() {
        return this.waiters.size();
    }

    public boolean startWaiter(String caller, long threadId) {
        ConditionWaiter key = new ConditionWaiter(caller, threadId);
        ConditionWaiter waiter = this.waiters.get(key);
        if (waiter == null) {
            throw new IllegalStateException();
        }
        if (waiter.started) {
            return false;
        }
        waiter.started = true;
        return true;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.conditionId);
        int len = this.waiters.size();
        out.writeInt(len);
        if (len > 0) {
            for (ConditionWaiter w : this.waiters.values()) {
                out.writeUTF(w.caller);
                out.writeLong(w.threadId);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.conditionId = in.readUTF();
        int len = in.readInt();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                ConditionWaiter waiter = new ConditionWaiter(in.readUTF(), in.readLong());
                this.waiters.put(waiter, waiter);
            }
        }
    }

    private static class ConditionWaiter {
        private final String caller;
        private final long threadId;
        private transient boolean started;

        ConditionWaiter(String caller, long threadId) {
            this.caller = caller;
            this.threadId = threadId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConditionWaiter that = (ConditionWaiter)o;
            if (this.threadId != that.threadId) {
                return false;
            }
            return !(this.caller != null ? !this.caller.equals(that.caller) : that.caller != null);
        }

        public int hashCode() {
            int result = this.caller != null ? this.caller.hashCode() : 0;
            result = 31 * result + (int)(this.threadId ^ this.threadId >>> 32);
            return result;
        }
    }
}

