/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.ByteArrayObjectDataInput;
import com.hazelcast.nio.UnsafeHelper;
import java.io.IOException;
import java.nio.ByteOrder;

class UnsafeObjectDataInput
extends ByteArrayObjectDataInput {
    UnsafeObjectDataInput(byte[] buffer, SerializationService service) {
        super(buffer, service, ByteOrder.nativeOrder());
    }

    UnsafeObjectDataInput(byte[] buffer, int offset, SerializationService service) {
        super(buffer, offset, service, ByteOrder.nativeOrder());
    }

    @Override
    public int read() throws IOException {
        return this.pos < this.size ? UnsafeHelper.UNSAFE.getByte(this.data, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos++) & 0xFF : -1;
    }

    @Override
    public int read(int position) throws IOException {
        return position < this.size ? (int)UnsafeHelper.UNSAFE.getByte(this.data, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position) : -1;
    }

    @Override
    public char readChar(int position) throws IOException {
        this.checkAvailable(position, 2);
        return UnsafeHelper.UNSAFE.getChar(this.data, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public double readDouble() throws IOException {
        double d = this.readDouble(this.pos);
        this.pos += 8;
        return d;
    }

    @Override
    public double readDouble(int position) throws IOException {
        this.checkAvailable(position, 8);
        return UnsafeHelper.UNSAFE.getDouble(this.data, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public float readFloat() throws IOException {
        float f = this.readFloat(this.pos);
        this.pos += 4;
        return f;
    }

    @Override
    public float readFloat(int position) throws IOException {
        this.checkAvailable(position, 4);
        return UnsafeHelper.UNSAFE.getFloat(this.data, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public int readInt(int position) throws IOException {
        this.checkAvailable(position, 4);
        return UnsafeHelper.UNSAFE.getInt(this.data, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public int readInt(int position, ByteOrder byteOrder) throws IOException {
        int v = this.readInt(position);
        if (byteOrder != ByteOrder.nativeOrder()) {
            v = Integer.reverseBytes(v);
        }
        return v;
    }

    @Override
    public long readLong(int position) throws IOException {
        this.checkAvailable(position, 8);
        return UnsafeHelper.UNSAFE.getLong(this.data, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public long readLong(int position, ByteOrder byteOrder) throws IOException {
        long v = this.readLong(position);
        if (byteOrder != ByteOrder.nativeOrder()) {
            v = Long.reverseBytes(v);
        }
        return v;
    }

    @Override
    public short readShort(int position) throws IOException {
        this.checkAvailable(position, 2);
        return UnsafeHelper.UNSAFE.getShort(this.data, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)position);
    }

    @Override
    public short readShort(int position, ByteOrder byteOrder) throws IOException {
        short v = this.readShort(position);
        if (byteOrder != ByteOrder.nativeOrder()) {
            v = Short.reverseBytes(v);
        }
        return v;
    }

    @Override
    public char[] readCharArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            char[] values = new char[len];
            this.memCopy(values, UnsafeHelper.CHAR_ARRAY_BASE_OFFSET, len, UnsafeHelper.CHAR_ARRAY_INDEX_SCALE);
            return values;
        }
        return new char[0];
    }

    @Override
    public boolean[] readBooleanArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            boolean[] values = new boolean[len];
            this.memCopy(values, UnsafeHelper.BOOLEAN_ARRAY_BASE_OFFSET, len, UnsafeHelper.BOOLEAN_ARRAY_INDEX_SCALE);
            return values;
        }
        return new boolean[0];
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            byte[] values = new byte[len];
            this.memCopy(values, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET, len, UnsafeHelper.BYTE_ARRAY_INDEX_SCALE);
            return values;
        }
        return new byte[0];
    }

    @Override
    public int[] readIntArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            int[] values = new int[len];
            this.memCopy(values, UnsafeHelper.INT_ARRAY_BASE_OFFSET, len, UnsafeHelper.INT_ARRAY_INDEX_SCALE);
            return values;
        }
        return new int[0];
    }

    @Override
    public long[] readLongArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            long[] values = new long[len];
            this.memCopy(values, UnsafeHelper.LONG_ARRAY_BASE_OFFSET, len, UnsafeHelper.LONG_ARRAY_INDEX_SCALE);
            return values;
        }
        return new long[0];
    }

    @Override
    public double[] readDoubleArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            double[] values = new double[len];
            this.memCopy(values, UnsafeHelper.DOUBLE_ARRAY_BASE_OFFSET, len, UnsafeHelper.DOUBLE_ARRAY_INDEX_SCALE);
            return values;
        }
        return new double[0];
    }

    @Override
    public float[] readFloatArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            float[] values = new float[len];
            this.memCopy(values, UnsafeHelper.FLOAT_ARRAY_BASE_OFFSET, len, UnsafeHelper.FLOAT_ARRAY_INDEX_SCALE);
            return values;
        }
        return new float[0];
    }

    @Override
    public short[] readShortArray() throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        if (len > 0) {
            short[] values = new short[len];
            this.memCopy(values, UnsafeHelper.SHORT_ARRAY_BASE_OFFSET, len, UnsafeHelper.SHORT_ARRAY_INDEX_SCALE);
            return values;
        }
        return new short[0];
    }

    private void memCopy(Object dest, long destOffset, int length, int indexScale) throws IOException {
        if (length < 0) {
            throw new NegativeArraySizeException("Destination length is negative: " + length);
        }
        int remaining = length * indexScale;
        this.checkAvailable(this.pos, remaining);
        long offset = destOffset;
        while (remaining > 0) {
            int chunk = remaining > 0x100000 ? 0x100000 : remaining;
            UnsafeHelper.UNSAFE.copyMemory(this.data, UnsafeHelper.BYTE_ARRAY_BASE_OFFSET + (long)this.pos, dest, offset, chunk);
            remaining -= chunk;
            offset += (long)chunk;
            this.pos += chunk;
        }
    }

    @Override
    public ByteOrder getByteOrder() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public String toString() {
        return "UnsafeObjectDataInput{size=" + this.size + ", pos=" + this.pos + ", mark=" + this.mark + ", byteOrder=" + this.getByteOrder() + '}';
    }
}

