/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.client.impl.client.AllPartitionsClientRequest;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableHook;
import com.hazelcast.replicatedmap.impl.operation.ClearOperationFactory;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.Map;

public class ClientReplicatedMapClearRequest
extends AllPartitionsClientRequest {
    private String mapName;

    ClientReplicatedMapClearRequest() {
    }

    public ClientReplicatedMapClearRequest(String name) {
        this.mapName = name;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new ClearOperationFactory(this.mapName);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        int deletedEntrySize = 0;
        for (Object deletedEntryPerPartition : map.values()) {
            deletedEntrySize += ((Integer)deletedEntryPerPartition).intValue();
        }
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedMapEventPublishingService eventPublishingService = service.getEventPublishingService();
        eventPublishingService.fireMapClearedEvent(deletedEntrySize, this.getDistributedObjectName());
        return null;
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 19;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.mapName, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return this.mapName;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public String getMethodName() {
        return "clear";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.mapName);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.mapName = reader.readUTF("n");
    }
}

