/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapEntries;
import com.hazelcast.replicatedmap.impl.operation.ReplicateUpdateOperation;
import com.hazelcast.replicatedmap.impl.operation.VersionResponsePair;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.OperationService;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class PutAllOperation
extends AbstractOperation {
    private String name;
    private ReplicatedMapEntries entries;
    private transient ReplicatedMapService service;
    private transient ReplicatedRecordStore store;

    public PutAllOperation() {
    }

    public PutAllOperation(String name, ReplicatedMapEntries entries) {
        this.name = name;
        this.entries = entries;
    }

    @Override
    public void run() throws Exception {
        int partitionId = this.getPartitionId();
        this.service = (ReplicatedMapService)this.getService();
        this.store = this.service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        InternalPartitionService partitionService = this.getNodeEngine().getPartitionService();
        for (Map.Entry<Data, Data> entry : this.entries.getEntries()) {
            Data key = entry.getKey();
            Data value = entry.getValue();
            if (partitionId != partitionService.getPartitionId(key)) continue;
            Object putResult = this.store.put(key, value);
            Data oldValue = this.getNodeEngine().toData(putResult);
            this.publishEvent(key, value, oldValue);
            VersionResponsePair response = new VersionResponsePair(putResult, this.store.getVersion());
            this.publishReplicationMessage(key, value, response);
        }
    }

    private void publishEvent(Data key, Data value, Data oldValue) {
        ReplicatedMapEventPublishingService eventPublishingService = this.service.getEventPublishingService();
        eventPublishingService.fireEntryListenerEvent(key, oldValue, value, this.name, this.getCallerAddress());
    }

    private void publishReplicationMessage(Data key, Data value, VersionResponsePair response) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Set<Member> members = this.getNodeEngine().getClusterService().getMembers();
        for (Member member : members) {
            Address address = member.getAddress();
            if (address.equals(this.getNodeEngine().getThisAddress())) continue;
            ReplicateUpdateOperation updateOperation = new ReplicateUpdateOperation(this.name, key, value, 0L, response, false, this.getCallerAddress());
            updateOperation.setPartitionId(this.getPartitionId());
            updateOperation.setValidateTarget(false);
            operationService.invokeOnTarget(this.getServiceName(), updateOperation, address);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.entries);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.entries = (ReplicatedMapEntries)in.readObject();
    }
}

