/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl.responses;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.operationservice.impl.responses.Response;
import java.io.IOException;

public class NormalResponse
extends Response {
    private Object value;
    private int backupCount;

    public NormalResponse() {
    }

    public NormalResponse(Object value, long callId, int backupCount, boolean urgent) {
        super(callId, urgent);
        this.value = value;
        this.backupCount = backupCount;
    }

    public Object getValue() {
        return this.value;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeInt(this.backupCount);
        boolean isData = this.value instanceof Data;
        out.writeBoolean(isData);
        if (isData) {
            out.writeData((Data)this.value);
        } else {
            out.writeObject(this.value);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.backupCount = in.readInt();
        boolean isData = in.readBoolean();
        this.value = isData ? in.readData() : in.readObject();
    }

    public String toString() {
        return "NormalResponse{callId=" + this.callId + ", urgent=" + this.urgent + ", value=" + this.value + ", backupCount=" + this.backupCount + '}';
    }
}

