/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.jdbc.impl.JDBCConnectionImpl;
import io.vertx.ext.jdbc.spi.DataSourceProvider;
import io.vertx.ext.sql.SQLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class JDBCClientImpl
implements JDBCClient {
    private static final String DS_LOCAL_MAP_NAME = "__vertx.JDBCClient.datasources";
    private final Vertx vertx;
    private final DataSourceHolder holder;
    private final ExecutorService exec;
    private final DataSource ds;
    private final PoolMetrics metrics;

    public JDBCClientImpl(Vertx vertx, DataSource dataSource) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(dataSource);
        this.vertx = vertx;
        this.holder = new DataSourceHolder((VertxInternal)vertx, dataSource);
        this.exec = this.holder.exec();
        this.ds = dataSource;
        this.metrics = this.holder.metrics;
        this.setupCloseHook();
    }

    public JDBCClientImpl(Vertx vertx, JsonObject config, String datasourceName) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(datasourceName);
        this.vertx = vertx;
        this.holder = this.lookupHolder(datasourceName, config);
        this.exec = this.holder.exec();
        this.ds = this.holder.ds();
        this.metrics = this.holder.metrics;
        this.setupCloseHook();
    }

    private void setupCloseHook() {
        Context ctx = Vertx.currentContext();
        if (ctx != null && ctx.owner() == this.vertx) {
            ctx.addCloseHook(this.holder::close);
        }
    }

    @Override
    public void close() {
        this.holder.close(null);
    }

    @Override
    public JDBCClient getConnection(Handler<AsyncResult<SQLConnection>> handler) {
        Context ctx = this.vertx.getOrCreateContext();
        boolean enabled = this.metrics != null && this.metrics.isEnabled();
        Object queueMetric = enabled ? this.metrics.submitted() : null;
        PoolMetrics metrics = enabled ? this.metrics : null;
        this.exec.execute(() -> {
            Future res = Future.future();
            try {
                Connection conn = this.ds.getConnection();
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                JDBCConnectionImpl sconn = new JDBCConnectionImpl(this.vertx, conn, metrics, execMetric);
                res.complete((Object)sconn);
            }
            catch (SQLException e) {
                if (metrics != null) {
                    metrics.rejected(queueMetric);
                }
                res.fail((Throwable)e);
            }
            ctx.runOnContext(v -> res.setHandler(handler));
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSourceHolder lookupHolder(String datasourceName, JsonObject config) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            LocalMap map = this.vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
            DataSourceHolder theHolder = (DataSourceHolder)map.get((Object)datasourceName);
            if (theHolder == null) {
                theHolder = new DataSourceHolder((VertxInternal)this.vertx, config, () -> this.removeFromMap((LocalMap<String, DataSourceHolder>)map, datasourceName), datasourceName);
                map.put((Object)datasourceName, (Object)theHolder);
            } else {
                theHolder.incRefCount();
            }
            return theHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, DataSourceHolder> map, String dataSourceName) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            map.remove((Object)dataSourceName);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }

    private class DataSourceHolder
    implements Shareable {
        private final VertxInternal vertx;
        DataSourceProvider provider;
        JsonObject config;
        Runnable closeRunner;
        DataSource ds;
        PoolMetrics metrics;
        ExecutorService exec;
        int refCount = 1;
        String name;

        public DataSourceHolder(VertxInternal vertx, DataSource ds) {
            this.ds = ds;
            this.metrics = vertx.metricsSPI().createMetrics((Object)ds, "datasource", UUID.randomUUID().toString(), -1);
            this.vertx = vertx;
        }

        public DataSourceHolder(VertxInternal vertx, JsonObject config, Runnable closeRunner, String name) {
            this.config = config;
            this.closeRunner = closeRunner;
            this.vertx = vertx;
            this.name = name;
        }

        synchronized DataSource ds() {
            if (this.ds == null) {
                String providerClass = this.config.getString("provider_class");
                if (providerClass == null) {
                    providerClass = "io.vertx.ext.jdbc.spi.impl.C3P0DataSourceProvider";
                }
                if (Thread.currentThread().getContextClassLoader() != null) {
                    try {
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(providerClass);
                        this.provider = (DataSourceProvider)clazz.newInstance();
                        this.ds = this.provider.getDataSource(this.config);
                        int poolSize = this.provider.maximumPoolSize(this.ds, this.config);
                        this.metrics = this.vertx.metricsSPI().createMetrics((Object)this.ds, "datasource", this.name, poolSize);
                        return this.ds;
                    }
                    catch (ClassNotFoundException clazz) {
                    }
                    catch (IllegalAccessException | InstantiationException | SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(providerClass);
                    this.provider = (DataSourceProvider)clazz.newInstance();
                    this.ds = this.provider.getDataSource(this.config);
                    int poolSize = this.provider.maximumPoolSize(this.ds, this.config);
                    this.metrics = this.vertx.metricsSPI().createMetrics((Object)this.ds, "datasource", this.name, poolSize);
                    return this.ds;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.ds;
        }

        synchronized ExecutorService exec() {
            if (this.exec == null) {
                this.exec = new ThreadPoolExecutor(1, 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "vertx-jdbc-service-get-connection-thread"));
            }
            return this.exec;
        }

        synchronized void incRefCount() {
            ++this.refCount;
        }

        synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
            if (--this.refCount == 0) {
                if (this.metrics != null) {
                    this.metrics.close();
                }
                Future f1 = Future.future();
                Future f2 = Future.future();
                if (completionHandler != null) {
                    CompositeFuture.all((Future)f1, (Future)f2).map(f -> null).setHandler(completionHandler);
                }
                if (this.provider != null) {
                    this.vertx.executeBlocking(future -> {
                        try {
                            this.provider.close(this.ds);
                            future.complete();
                        }
                        catch (SQLException e) {
                            future.fail((Throwable)e);
                        }
                    }, f2.completer());
                } else {
                    f2.complete();
                }
                try {
                    if (this.exec != null) {
                        this.exec.shutdown();
                    }
                    if (this.closeRunner != null) {
                        this.closeRunner.run();
                    }
                    f1.complete();
                }
                catch (Throwable t) {
                    f1.fail(t);
                }
            } else if (completionHandler != null) {
                completionHandler.handle((Object)Future.succeededFuture());
            }
        }
    }
}

