/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jdbc.impl.actions;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractJDBCAction<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractJDBCAction.class);
    protected final Vertx vertx;
    protected final Connection conn;
    protected final WorkerExecutor exec;

    protected AbstractJDBCAction(Vertx vertx, Connection conn, WorkerExecutor exec) {
        this.vertx = vertx;
        this.conn = conn;
        this.exec = exec;
    }

    public void handle(Future<T> future) {
        try {
            T result = this.execute();
            future.complete(result);
        }
        catch (SQLException e) {
            future.fail((Throwable)e);
        }
    }

    public void execute(Handler<AsyncResult<T>> resultHandler) {
        this.exec.executeBlocking(this::handle, resultHandler);
    }

    protected abstract T execute() throws SQLException;

    protected abstract String name();
}

