/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.impl.ProtonConnectionImpl;
import io.vertx.proton.impl.ProtonDeliveryImpl;
import io.vertx.proton.impl.ProtonLinkImpl;
import io.vertx.proton.impl.ProtonReceiverImpl;
import io.vertx.proton.impl.ProtonSessionImpl;
import io.vertx.proton.sasl.ProtonSaslAuthenticator;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.TransportException;

class ProtonTransport
extends BaseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonTransport.class);
    private final Connection connection;
    private final Vertx vertx;
    private final NetClient netClient;
    private final NetSocket socket;
    private final Transport transport = Proton.transport();
    private final Collector collector = Proton.collector();
    private ProtonSaslAuthenticator authenticator;
    private volatile Long idleTimeoutCheckTimerId;
    private boolean failed;

    ProtonTransport(Connection connection, Vertx vertx, NetClient netClient, NetSocket socket, ProtonSaslAuthenticator authenticator) {
        this.connection = connection;
        this.vertx = vertx;
        this.netClient = netClient;
        this.socket = socket;
        this.transport.setMaxFrameSize(32768);
        this.transport.setEmitFlowEventOnSend(false);
        if (authenticator != null) {
            authenticator.init(this.socket, (ProtonConnection)this.connection.getContext(), this.transport);
        }
        this.authenticator = authenticator;
        this.transport.bind(connection);
        connection.collect(this.collector);
        socket.endHandler(this::handleSocketEnd);
        socket.handler(this::handleSocketBuffer);
    }

    private void handleSocketEnd(Void arg) {
        this.transport.unbind();
        this.transport.close();
        if (this.netClient != null) {
            this.netClient.close();
        } else {
            this.socket.close();
        }
        ((ProtonConnectionImpl)this.connection.getContext()).fireDisconnect();
    }

    private void handleSocketBuffer(Buffer buff) {
        this.pumpInbound(ByteBuffer.wrap(buff.getBytes()));
        Event protonEvent = null;
        while ((protonEvent = this.collector.peek()) != null) {
            ProtonConnectionImpl connnection = (ProtonConnectionImpl)protonEvent.getConnection().getContext();
            Event.Type eventType = protonEvent.getType();
            if (LOG.isTraceEnabled() && !eventType.equals((Object)Event.Type.TRANSPORT)) {
                LOG.trace((Object)"New Proton Event: {0}", new Object[]{eventType});
            }
            switch (eventType) {
                case CONNECTION_REMOTE_OPEN: {
                    connnection.fireRemoteOpen();
                    this.initiateIdleTimeoutChecks();
                    break;
                }
                case CONNECTION_REMOTE_CLOSE: {
                    connnection.fireRemoteClose();
                    break;
                }
                case SESSION_REMOTE_OPEN: {
                    ProtonSessionImpl session = (ProtonSessionImpl)protonEvent.getSession().getContext();
                    if (session == null) {
                        connnection.fireRemoteSessionOpen(protonEvent.getSession());
                        break;
                    }
                    session.fireRemoteOpen();
                    break;
                }
                case SESSION_REMOTE_CLOSE: {
                    ProtonSessionImpl session = (ProtonSessionImpl)protonEvent.getSession().getContext();
                    session.fireRemoteClose();
                    break;
                }
                case LINK_REMOTE_OPEN: {
                    ProtonLinkImpl link = (ProtonLinkImpl)protonEvent.getLink().getContext();
                    if (link == null) {
                        connnection.fireRemoteLinkOpen(protonEvent.getLink());
                        break;
                    }
                    link.fireRemoteOpen();
                    break;
                }
                case LINK_REMOTE_CLOSE: {
                    ProtonLinkImpl link = (ProtonLinkImpl)protonEvent.getLink().getContext();
                    link.fireRemoteClose();
                    break;
                }
                case LINK_FLOW: {
                    ProtonLinkImpl link = (ProtonLinkImpl)protonEvent.getLink().getContext();
                    link.fireLinkFlow();
                    break;
                }
                case DELIVERY: {
                    ProtonDeliveryImpl delivery = (ProtonDeliveryImpl)protonEvent.getDelivery().getContext();
                    if (delivery != null) {
                        delivery.fireUpdate();
                        break;
                    }
                    ProtonReceiverImpl receiver = (ProtonReceiverImpl)protonEvent.getLink().getContext();
                    receiver.onDelivery();
                    break;
                }
                case TRANSPORT_ERROR: {
                    this.failed = true;
                    break;
                }
            }
            this.collector.pop();
        }
        this.processSaslAuthentication();
        this.flush();
    }

    private void processSaslAuthentication() {
        if (this.authenticator == null) {
            return;
        }
        if (this.authenticator.process()) {
            this.authenticator = null;
        }
    }

    private void initiateIdleTimeoutChecks() {
        long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        long deadline = this.transport.tick(now);
        if (deadline > 0L) {
            long delay = deadline - now;
            LOG.trace((Object)"IdleTimeoutCheck being initiated, initial delay: {0}", new Object[]{delay});
            this.idleTimeoutCheckTimerId = this.vertx.setTimer(delay, (Handler)new IdleTimeoutCheck());
        }
    }

    private void pumpInbound(ByteBuffer bytes) {
        if (this.failed) {
            LOG.trace((Object)"Skipping processing of data following transport error: {0}", new Object[]{bytes});
            return;
        }
        ByteBuffer inputBuffer = this.transport.getInputBuffer();
        while (bytes.hasRemaining() && inputBuffer.hasRemaining()) {
            inputBuffer.put(bytes.get());
            try {
                this.transport.processInput().checkIsOk();
            }
            catch (TransportException te) {
                this.failed = true;
            }
        }
    }

    void flush() {
        boolean done = false;
        while (!done) {
            ByteBuffer outputBuffer = this.transport.getOutputBuffer();
            if (outputBuffer != null && outputBuffer.hasRemaining()) {
                byte[] buffer = new byte[outputBuffer.remaining()];
                outputBuffer.get(buffer);
                this.socket.write(Buffer.buffer((byte[])buffer));
                this.transport.outputConsumed();
                continue;
            }
            done = true;
        }
    }

    public void disconnect() {
        if (this.netClient != null) {
            this.netClient.close();
        } else {
            this.socket.close();
        }
    }

    private final class IdleTimeoutCheck
    implements Handler<Long> {
        private IdleTimeoutCheck() {
        }

        public void handle(Long event) {
            boolean checkScheduled = false;
            if (ProtonTransport.this.connection.getLocalState() == EndpointState.ACTIVE) {
                long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                long deadline = ProtonTransport.this.transport.tick(now);
                ProtonTransport.this.flush();
                if (ProtonTransport.this.transport.isClosed()) {
                    LOG.info((Object)"IdleTimeoutCheck closed the transport due to the peer exceeding our requested idle-timeout.");
                    ProtonTransport.this.disconnect();
                } else if (deadline > 0L) {
                    long delay = deadline - now;
                    checkScheduled = true;
                    LOG.trace((Object)"IdleTimeoutCheck rescheduling with delay: {0}", new Object[]{delay});
                    ProtonTransport.this.idleTimeoutCheckTimerId = ProtonTransport.this.vertx.setTimer(delay, (Handler)this);
                }
            } else {
                LOG.trace((Object)"IdleTimeoutCheck skipping check, connection is not active.");
            }
            if (!checkScheduled) {
                ProtonTransport.this.idleTimeoutCheckTimerId = null;
                LOG.trace((Object)"IdleTimeoutCheck exiting");
            }
        }
    }
}

