/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.report.Failure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class FailureImpl
implements Failure {
    private final boolean error;
    private final String message;
    private final String stackTrace;
    private final Throwable cause;

    public FailureImpl(JsonObject json) {
        byte[] tmp = json.getBinary("cause");
        Throwable t = null;
        if (tmp != null) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(tmp));
                t = (Throwable)ois.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.error = json.getBoolean("error");
        this.message = json.getString("message");
        this.stackTrace = json.getString("stackTrace");
        this.cause = t;
    }

    public FailureImpl(boolean error, String message, String stackTrace, Throwable cause) {
        this.error = error;
        this.message = message;
        this.stackTrace = stackTrace;
        this.cause = cause;
    }

    public FailureImpl(Throwable t) {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        t.printStackTrace(writer);
        writer.close();
        this.error = !(t instanceof AssertionError);
        this.stackTrace = buffer.toString();
        this.cause = t;
        this.message = t.getMessage();
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public String stackTrace() {
        return this.stackTrace;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject().put("error", Boolean.valueOf(this.error)).put("message", this.message).put("stackTrace", this.stackTrace);
        if (this.cause != null) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = new ObjectOutputStream(buffer);){
                oos.flush();
                oos.writeObject(this.cause);
                json.put("cause", buffer.toByteArray());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return json;
    }
}

