/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.report.impl;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.unit.report.ReportOptions;
import io.vertx.ext.unit.report.Reporter;
import io.vertx.ext.unit.report.ReporterFactory;
import io.vertx.ext.unit.report.impl.EventBusReporter;
import io.vertx.ext.unit.report.impl.JunitXmlFormatter;
import io.vertx.ext.unit.report.impl.ReportStream;
import io.vertx.ext.unit.report.impl.SimpleFormatter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.function.BiFunction;

public class DefaultReporterFactory
implements ReporterFactory {
    @Override
    public Reporter reporter(Vertx vertx, ReportOptions options) {
        String format;
        BiFunction<String, String, ReportStream> streamFactory;
        String location;
        String prefix;
        String to = options.getTo();
        int pos = to.indexOf(58);
        if (pos != -1) {
            prefix = to.substring(0, pos);
            location = to.substring(pos + 1);
        } else {
            prefix = to;
            location = null;
        }
        if (prefix.equals("bus")) {
            if (location == null) {
                throw new IllegalArgumentException("Invalid bus report configuration: " + to + " must follow bus: + address");
            }
            if (vertx == null) {
                throw new IllegalArgumentException("No vertx provided for event bus reporting");
            }
            return new EventBusReporter(vertx, location);
        }
        switch (prefix) {
            case "console": {
                streamFactory = (name, ext) -> new ReportStream(){

                    @Override
                    public void info(Buffer msg) {
                        System.out.print(msg.toString("UTF-8"));
                    }

                    @Override
                    public void error(Buffer msg, Throwable cause) {
                        System.err.print(msg.toString("UTF-8"));
                        cause.printStackTrace(System.err);
                    }
                };
                break;
            }
            case "log": {
                if (location == null) {
                    throw new IllegalArgumentException("Invalid log report configuration: " + to + " must follow log: + address");
                }
                final Logger log = LoggerFactory.getLogger((String)location);
                streamFactory = (name, ext) -> new ReportStream(){

                    @Override
                    public void info(Buffer msg) {
                        log.info((Object)msg.toString("UTF-8"));
                    }

                    @Override
                    public void error(Buffer msg, Throwable cause) {
                        log.error((Object)msg.toString("UTF-8"), cause);
                    }
                };
                break;
            }
            case "file": {
                if (location == null) {
                    throw new IllegalArgumentException("Invalid file report configuration: " + to + " must follow file: + address");
                }
                if (vertx == null) {
                    throw new IllegalArgumentException("No vertx provided for filesystem reporting");
                }
                streamFactory = (name, ext) -> {
                    String fileName = location + File.separator + name + "." + ext;
                    final AsyncFile file = vertx.fileSystem().openBlocking(fileName, new OpenOptions());
                    final PrintWriter writer = new PrintWriter(new Writer(){

                        @Override
                        public void write(char[] cbuf, int off, int len) throws IOException {
                            file.write(Buffer.buffer((String)new String(cbuf, off, len)));
                        }

                        @Override
                        public void flush() throws IOException {
                            file.flush();
                        }

                        @Override
                        public void close() throws IOException {
                            file.close();
                        }
                    });
                    return new ReportStream(){

                        @Override
                        public void info(Buffer msg) {
                            file.write(msg);
                        }

                        @Override
                        public void error(Buffer msg, Throwable cause) {
                            writer.println(msg.toString("UTF-8"));
                            cause.printStackTrace(writer);
                        }

                        @Override
                        public void end() {
                            writer.close();
                        }
                    };
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal reporter name <" + to + ">");
            }
        }
        switch (format = options.getFormat()) {
            case "simple": {
                return new SimpleFormatter(name -> (ReportStream)streamFactory.apply((String)name, "txt"));
            }
            case "junit": {
                return new JunitXmlFormatter(name -> (ReportStream)streamFactory.apply((String)name, "xml"));
            }
        }
        throw new IllegalArgumentException("Invalid format <" + format + ">");
    }
}

