/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.report.impl;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.impl.FailureImpl;
import io.vertx.ext.unit.report.Failure;
import io.vertx.ext.unit.report.Reporter;
import io.vertx.ext.unit.report.TestResult;

public class EventBusReporter
implements Reporter<EventBusReport> {
    private final Vertx vertx;
    private final String address;

    public EventBusReporter(Vertx vertx, String address) {
        this.vertx = vertx;
        this.address = address;
    }

    @Override
    public EventBusReport reportBeginTestSuite(String name) {
        EventBusReport report = new EventBusReport(name);
        this.vertx.eventBus().publish(this.address, (Object)new JsonObject().put("type", "testSuiteBegin").put("name", name));
        return report;
    }

    @Override
    public void reportBeginTestCase(EventBusReport report, String name) {
        this.vertx.eventBus().publish(this.address, (Object)new JsonObject().put("type", "testCaseBegin").put("name", name));
    }

    @Override
    public void reportEndTestCase(EventBusReport report, String name, TestResult result) {
        JsonObject json = new JsonObject().put("type", "testCaseEnd").put("name", result.name()).put("beginTime", Long.valueOf(result.beginTime())).put("durationTime", Long.valueOf(result.durationTime()));
        if (result.failed()) {
            Failure failure = result.failure();
            json.put("failure", ((FailureImpl)failure).toJson());
        }
        this.vertx.eventBus().publish(this.address, (Object)json);
    }

    @Override
    public void reportError(EventBusReport report, Throwable err) {
        JsonObject msg = new JsonObject().put("type", "testSuiteError");
        msg.put("failure", new FailureImpl(err).toJson());
        this.vertx.eventBus().publish(this.address, (Object)msg);
    }

    @Override
    public void reportEndTestSuite(EventBusReport report) {
        JsonObject msg = new JsonObject().put("type", "testSuiteEnd").put("name", report.name);
        this.vertx.eventBus().publish(this.address, (Object)msg);
    }

    public static class EventBusReport {
        final String name;

        public EventBusReport(String name) {
            this.name = name;
        }
    }
}

