/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class FindOptions {
    public static final int DEFAULT_LIMIT = -1;
    public static final int DEFAULT_SKIP = 0;
    private JsonObject fields;
    private JsonObject sort;
    private int limit;
    private int skip;

    public FindOptions() {
        this.limit = -1;
        this.skip = 0;
    }

    public FindOptions(FindOptions other) {
        this.fields = other.fields;
        this.sort = other.sort;
        this.limit = other.limit;
        this.skip = other.skip;
    }

    public FindOptions(JsonObject json) {
        this.fields = json.getJsonObject("fields");
        this.sort = json.getJsonObject("sort");
        this.limit = json.getInteger("limit", Integer.valueOf(-1));
        this.skip = json.getInteger("skip", Integer.valueOf(0));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.fields != null) {
            json.put("fields", this.fields);
        }
        if (this.sort != null) {
            json.put("sort", this.sort);
        }
        if (this.limit != -1) {
            json.put("limit", Integer.valueOf(this.limit));
        }
        if (this.skip != 0) {
            json.put("skip", Integer.valueOf(this.skip));
        }
        return json;
    }

    public JsonObject getFields() {
        return this.fields;
    }

    public FindOptions setFields(JsonObject fields) {
        this.fields = fields;
        return this;
    }

    public JsonObject getSort() {
        return this.sort;
    }

    public FindOptions setSort(JsonObject sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOptions setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOptions setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindOptions options = (FindOptions)o;
        if (this.limit != options.limit) {
            return false;
        }
        if (this.skip != options.skip) {
            return false;
        }
        if (this.fields != null ? !this.fields.equals((Object)options.fields) : options.fields != null) {
            return false;
        }
        return !(this.sort != null ? !this.sort.equals((Object)options.sort) : options.sort != null);
    }

    public int hashCode() {
        int result = this.fields != null ? this.fields.hashCode() : 0;
        result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
        result = 31 * result + this.limit;
        result = 31 * result + this.skip;
        return result;
    }
}

