/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.core.shareddata.LocalMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class LocalMapWrapper<K, V>
implements Map<K, V> {
    private final LocalMap<K, V> local;

    public LocalMapWrapper(LocalMap<K, V> local) {
        this.local = local;
    }

    public boolean replaceIfPresent(K key, V oldValue, V newValue) {
        return this.local.replaceIfPresent(key, oldValue, newValue);
    }

    public void close() {
        this.local.close();
    }

    public boolean removeIfPresent(K key, V value) {
        return this.local.removeIfPresent(key, value);
    }

    @Override
    public Collection<V> values() {
        return this.local.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
        for (final Object key : this.local.keySet()) {
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return LocalMapWrapper.this.local.get(key);
                }

                @Override
                public V setValue(V value) {
                    return LocalMapWrapper.this.local.put(key, value);
                }
            });
        }
        return entries;
    }

    @Override
    public int size() {
        return this.local.size();
    }

    @Override
    public V replace(K key, V value) {
        return (V)this.local.replace(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)this.local.putIfAbsent(key, value);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.local.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return (V)this.local.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.local.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        return this.local.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.local.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.local.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.local.values().contains(value);
    }

    @Override
    public V get(Object key) {
        return (V)this.local.get(key);
    }

    @Override
    public void clear() {
        this.local.clear();
    }
}

