/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.impl;

import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.spi.ServiceType;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;

public class ServiceTypes {
    private static ServiceLoader<ServiceType> types;

    public static ServiceType get(Record record) {
        ServiceTypes.load();
        String type = record.getType();
        Objects.requireNonNull(type);
        ServiceType found = ServiceTypes.get(type);
        if (found != null) {
            return found;
        }
        throw new IllegalArgumentException("Unsupported service type " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        Class<ServiceTypes> clazz = ServiceTypes.class;
        synchronized (ServiceTypes.class) {
            if (types == null || !types.iterator().hasNext()) {
                types = ServiceLoader.load(ServiceType.class);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Iterator<ServiceType> all() {
        ServiceTypes.load();
        return types.iterator();
    }

    public static ServiceType get(String type) {
        ServiceTypes.load();
        for (ServiceType next : types) {
            if (!next.name().equalsIgnoreCase(type)) continue;
            return next;
        }
        return null;
    }
}

