/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types.impl;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.types.AbstractServiceReference;
import io.vertx.servicediscovery.types.EventBusService;
import io.vertx.servicediscovery.utils.ClassLoaderUtils;
import io.vertx.serviceproxy.ProxyHelper;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class EventBusServiceImpl
implements EventBusService {
    @Override
    public String name() {
        return "eventbus-service-proxy";
    }

    @Override
    public ServiceReference get(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject configuration) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(record);
        Objects.requireNonNull(discovery);
        return new EventBusServiceReference(vertx, discovery, record, configuration);
    }

    private class EventBusServiceReference
    extends AbstractServiceReference<Object> {
        private final DeliveryOptions deliveryOptions;
        private final String clientClass;
        private final String serviceInterface;

        EventBusServiceReference(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject conf) {
            super(vertx, discovery, record);
            this.serviceInterface = record.getMetadata().getString("service.interface");
            if (conf != null) {
                this.clientClass = conf.getString("client.class");
                this.deliveryOptions = new DeliveryOptions(conf);
            } else {
                this.clientClass = this.serviceInterface;
                this.deliveryOptions = null;
            }
            Objects.requireNonNull(this.serviceInterface);
        }

        @Override
        public synchronized Object retrieve() {
            Class itf = ClassLoaderUtils.load(this.serviceInterface, this.getClass().getClassLoader());
            if (itf == null) {
                throw new IllegalStateException("Cannot load class " + this.clientClass);
            }
            Object proxy = ProxyHelper.createProxy(itf, (Vertx)this.vertx, (String)this.record().getLocation().getString("endpoint"), (DeliveryOptions)this.deliveryOptions);
            if (this.clientClass != null) {
                try {
                    Class client = ClassLoaderUtils.load(this.clientClass, this.getClass().getClassLoader());
                    Constructor constructor = client.getConstructor(Object.class);
                    return constructor.newInstance(proxy);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return proxy;
        }
    }
}

