/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.types.AbstractServiceReference;
import io.vertx.servicediscovery.types.HttpEndpoint;
import io.vertx.servicediscovery.types.HttpLocation;
import java.util.Objects;

public class HttpEndpointImpl
implements HttpEndpoint {
    @Override
    public String name() {
        return "http-endpoint";
    }

    @Override
    public ServiceReference get(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject configuration) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(record);
        Objects.requireNonNull(discovery);
        return new HttpEndpointReference(vertx, discovery, record, configuration);
    }

    private class HttpEndpointReference
    extends AbstractServiceReference<HttpClient> {
        private final HttpLocation location;
        private final JsonObject config;

        HttpEndpointReference(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject config) {
            super(vertx, discovery, record);
            this.config = config;
            this.location = new HttpLocation(record.getLocation());
        }

        @Override
        public HttpClient retrieve() {
            HttpClientOptions options = this.config != null ? new HttpClientOptions(this.config) : new HttpClientOptions();
            options.setDefaultPort(this.location.getPort()).setDefaultHost(this.location.getHost());
            if (this.location.isSsl()) {
                options.setSsl(true);
            }
            return this.vertx.createHttpClient(options);
        }

        @Override
        public void close() {
            ((HttpClient)this.service).close();
        }
    }
}

