/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.reactivestreams.impl;

import io.vertx.core.Handler;
import io.vertx.ext.reactivestreams.ReactiveReadStream;
import java.util.ArrayDeque;
import java.util.Queue;
import org.reactivestreams.Subscription;

public class ReactiveReadStreamImpl<T>
implements ReactiveReadStream<T> {
    private final long batchSize;
    private Handler<T> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private Subscription subscription;
    private final Queue<T> pending = new ArrayDeque<T>();
    private boolean paused;
    private long tokens;

    public ReactiveReadStreamImpl(long batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public synchronized ReactiveReadStream<T> handler(Handler<T> handler) {
        this.dataHandler = handler;
        if (this.dataHandler != null && !this.paused) {
            this.checkRequestTokens();
        }
        return this;
    }

    @Override
    public synchronized ReactiveReadStream<T> pause() {
        this.paused = true;
        return this;
    }

    @Override
    public synchronized ReactiveReadStream<T> resume() {
        T data;
        this.paused = false;
        while ((data = this.pending.poll()) != null) {
            this.handleData(data);
        }
        this.checkRequestTokens();
        return this;
    }

    @Override
    public synchronized ReactiveReadStream<T> endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return this;
    }

    @Override
    public synchronized ReactiveReadStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public synchronized void onSubscribe(Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription");
        }
        if (this.subscription != null) {
            subscription.cancel();
        } else {
            this.subscription = subscription;
        }
    }

    public synchronized void onNext(T data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.checkUnsolicitedTokens();
        this.handleData(data);
    }

    public synchronized void onError(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable");
        }
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle((Object)throwable);
        }
    }

    public synchronized void onComplete() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    protected void checkUnsolicitedTokens() {
        if (this.tokens == 0L) {
            throw new IllegalStateException("Data received but wasn't requested");
        }
    }

    private synchronized void handleData(T data) {
        if (this.paused) {
            this.pending.add(data);
        } else if (this.dataHandler != null) {
            this.dataHandler.handle(data);
            --this.tokens;
            this.checkRequestTokens();
        }
    }

    private void checkRequestTokens() {
        if (!this.paused && this.subscription != null && this.tokens == 0L) {
            this.tokens = this.batchSize;
            this.subscription.request(this.batchSize);
        }
    }
}

