/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateparser.text;

import org.thymeleaf.templateparser.text.AbstractChainedTextHandler;
import org.thymeleaf.templateparser.text.ITextHandler;
import org.thymeleaf.templateparser.text.ParsingLocatorUtil;
import org.thymeleaf.templateparser.text.TextParseException;
import org.thymeleaf.templateparser.text.TextParsingElementUtil;

final class CommentProcessorTextHandler
extends AbstractChainedTextHandler {
    private final boolean standardDialectPresent;
    private boolean filterTexts = false;
    private int[] locator = new int[2];

    CommentProcessorTextHandler(boolean standardDialectPresent, ITextHandler handler) {
        super(handler);
        this.standardDialectPresent = standardDialectPresent;
    }

    @Override
    public void handleComment(char[] buffer, int contentOffset, int contentLen, int outerOffset, int outerLen, int line, int col) throws TextParseException {
        this.filterTexts = false;
        if (!this.isCommentProcessable(buffer, contentOffset, contentLen)) {
            super.handleText(buffer, outerOffset, outerLen, line, col);
            return;
        }
        int maxi = contentOffset + contentLen;
        if (TextParsingElementUtil.isOpenElementStart(buffer, contentOffset, maxi)) {
            if (TextParsingElementUtil.isElementEnd(buffer, maxi - 2, maxi, true)) {
                TextParsingElementUtil.parseStandaloneElement(buffer, contentOffset, contentLen, line, col + 2, this.getNext());
                return;
            }
            if (TextParsingElementUtil.isElementEnd(buffer, maxi - 1, maxi, false)) {
                TextParsingElementUtil.parseOpenElement(buffer, contentOffset, contentLen, line, col + 2, this.getNext());
                return;
            }
        } else if (TextParsingElementUtil.isCloseElementStart(buffer, contentOffset, maxi) && TextParsingElementUtil.isElementEnd(buffer, maxi - 1, maxi, false)) {
            TextParsingElementUtil.parseCloseElement(buffer, contentOffset, contentLen, line, col + 2, this.getNext());
            return;
        }
        if (this.standardDialectPresent) {
            this.getNext().handleText(buffer, contentOffset, contentLen, line, col + 2);
            this.filterTexts = true;
        } else {
            this.getNext().handleText(buffer, outerOffset, outerLen, line, col);
        }
    }

    private boolean isCommentProcessable(char[] buffer, int contentOffset, int contentLen) {
        int maxi = contentOffset + contentLen;
        if (contentLen < 3 || buffer[contentOffset] != '[' || buffer[maxi - 1] != ']') {
            return false;
        }
        if (contentLen >= 4 && buffer[contentOffset + 1] == '(' && buffer[maxi - 2] == ')') {
            return true;
        }
        if (contentLen >= 4 && buffer[contentOffset + 1] == '[' && buffer[maxi - 2] == ']') {
            return true;
        }
        if (TextParsingElementUtil.isOpenElementStart(buffer, contentOffset, maxi)) {
            return TextParsingElementUtil.isElementEnd(buffer, maxi - 1, maxi, false);
        }
        if (TextParsingElementUtil.isCloseElementStart(buffer, contentOffset, maxi)) {
            return TextParsingElementUtil.isElementEnd(buffer, maxi - 1, maxi, false);
        }
        return false;
    }

    @Override
    public void handleText(char[] buffer, int offset, int len, int line, int col) throws TextParseException {
        if (this.filterTexts) {
            this.locator[0] = line;
            this.locator[1] = col;
            int maxi = offset + len;
            int filterOffset = CommentProcessorTextHandler.computeFilterOffset(buffer, offset, maxi, this.locator);
            if (filterOffset < maxi) {
                super.handleText(buffer, filterOffset, maxi - filterOffset, this.locator[0], this.locator[1]);
                this.filterTexts = false;
            }
            return;
        }
        super.handleText(buffer, offset, len, line, col);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws TextParseException {
        this.filterTexts = false;
        super.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        this.filterTexts = false;
        super.handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        this.filterTexts = false;
        super.handleCloseElementStart(buffer, nameOffset, nameLen, line, col);
    }

    private static int computeFilterOffset(char[] buffer, int offset, int maxi, int[] locator) {
        if (offset == maxi) {
            return 0;
        }
        char literalDelimiter = '\u0000';
        int arrayLevel = 0;
        int objectLevel = 0;
        int i = offset;
        while (i < maxi) {
            char c = buffer[i++];
            if (literalDelimiter != '\u0000') {
                if (c == literalDelimiter && buffer[i - 2] != '\\') {
                    literalDelimiter = '\u0000';
                }
                ParsingLocatorUtil.countChar(locator, c);
                continue;
            }
            if (c == '\'' || c == '\"') {
                literalDelimiter = c;
                ParsingLocatorUtil.countChar(locator, c);
                continue;
            }
            if (c == '{') {
                ++objectLevel;
                ParsingLocatorUtil.countChar(locator, c);
                continue;
            }
            if (objectLevel > 0 && c == '}') {
                --objectLevel;
                ParsingLocatorUtil.countChar(locator, c);
                continue;
            }
            if (c == '[') {
                ++arrayLevel;
                ParsingLocatorUtil.countChar(locator, c);
                continue;
            }
            if (arrayLevel > 0 && c == ']') {
                --arrayLevel;
                ParsingLocatorUtil.countChar(locator, c);
                continue;
            }
            if (arrayLevel == 0 && objectLevel == 0) {
                if (c == '\n') {
                    return i - 1;
                }
                if (c == ';' || c == ',' || c == ')' || c == '}' || c == ']') {
                    return i - 1;
                }
                if (c == '/' && i < maxi && buffer[i] == '/') {
                    return i - 1;
                }
            }
            ParsingLocatorUtil.countChar(locator, c);
        }
        return maxi;
    }
}

