/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateresource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.TemplateResourceUtils;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class UrlTemplateResource
implements ITemplateResource,
Serializable {
    private final URL url;
    private final String characterEncoding;

    public UrlTemplateResource(String path, String characterEncoding) throws MalformedURLException {
        Validate.notEmpty(path, "Resource Path cannot be null or empty");
        this.url = new URL(path);
        this.characterEncoding = characterEncoding;
    }

    public UrlTemplateResource(URL url, String characterEncoding) {
        Validate.notNull(url, "Resource URL cannot be null");
        this.url = url;
        this.characterEncoding = characterEncoding;
    }

    @Override
    public String getDescription() {
        return this.url.toString();
    }

    @Override
    public String getBaseName() {
        return TemplateResourceUtils.computeBaseName(TemplateResourceUtils.cleanPath(this.url.getPath()));
    }

    @Override
    public Reader reader() throws IOException {
        InputStream inputStream = this.inputStream();
        if (!StringUtils.isEmptyOrWhitespace(this.characterEncoding)) {
            return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), this.characterEncoding));
        }
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
    }

    private InputStream inputStream() throws IOException {
        InputStream inputStream;
        URLConnection connection = this.url.openConnection();
        if (connection.getClass().getSimpleName().startsWith("JNLP")) {
            connection.setUseCaches(true);
        }
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException e) {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
            throw e;
        }
        return inputStream;
    }

    @Override
    public ITemplateResource relative(String relativeLocation) {
        URL relativeURL;
        Validate.notEmpty(relativeLocation, "Relative Path cannot be null or empty");
        try {
            relativeURL = new URL(this.url, relativeLocation.charAt(0) == '/' ? relativeLocation.substring(1) : relativeLocation);
        }
        catch (MalformedURLException e) {
            throw new TemplateInputException("Could not create relative URL resource for resource \"" + this.getDescription() + "\" and " + "relative location \"" + relativeLocation + "\"", e);
        }
        return new UrlTemplateResource(relativeURL, this.characterEncoding);
    }

    @Override
    public boolean exists() {
        try {
            String protocol = this.url.getProtocol();
            if ("file".equals(protocol)) {
                File file = null;
                try {
                    file = new File(UrlTemplateResource.toURI(this.url).getSchemeSpecificPart());
                }
                catch (URISyntaxException ignored) {
                    file = new File(this.url.getFile());
                }
                return file.exists();
            }
            URLConnection connection = this.url.openConnection();
            if (connection.getClass().getSimpleName().startsWith("JNLP")) {
                connection.setUseCaches(true);
            }
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.setRequestMethod("HEAD");
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 200) {
                    return true;
                }
                if (responseCode == 404) {
                    return false;
                }
                if (httpConnection.getContentLength() >= 0) {
                    return true;
                }
                httpConnection.disconnect();
                return false;
            }
            if (connection.getContentLength() >= 0) {
                return true;
            }
            InputStream is = this.inputStream();
            is.close();
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static URI toURI(URL url) throws URISyntaxException {
        String location = url.toString();
        if (location.indexOf(32) == -1) {
            return new URI(location);
        }
        return new URI(StringUtils.replace(location, " ", "%20"));
    }
}

