/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.util.internal.EmptyArrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

final class HuffmanDecoder {
    private static final IOException EOS_DECODED = new IOException("HPACK - EOS Decoded");
    private static final IOException INVALID_PADDING = new IOException("HPACK - Invalid Padding");
    private final Node root;

    HuffmanDecoder(int[] codes, byte[] lengths) {
        if (codes.length != 257 || codes.length != lengths.length) {
            throw new IllegalArgumentException("invalid Huffman coding");
        }
        this.root = HuffmanDecoder.buildTree(codes, lengths);
    }

    public byte[] decode(byte[] buf) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Node node = this.root;
        int current = 0;
        int currentBits = 0;
        int symbolBits = 0;
        for (int i = 0; i < buf.length; ++i) {
            int b = buf[i] & 0xFF;
            current = current << 8 | b;
            currentBits += 8;
            symbolBits += 8;
            while (currentBits >= 8) {
                int c = current >>> currentBits - 8 & 0xFF;
                node = node.children[c];
                currentBits -= node.bits;
                if (!node.isTerminal()) continue;
                if (node.symbol == 256) {
                    throw EOS_DECODED;
                }
                baos.write(node.symbol);
                node = this.root;
                symbolBits = currentBits;
            }
        }
        while (currentBits > 0) {
            int c = current << 8 - currentBits & 0xFF;
            if (!(node = node.children[c]).isTerminal() || node.bits > currentBits) break;
            if (node.symbol == 256) {
                throw EOS_DECODED;
            }
            currentBits -= node.bits;
            baos.write(node.symbol);
            node = this.root;
            symbolBits = currentBits;
        }
        int mask = (1 << symbolBits) - 1;
        if (symbolBits > 7 || (current & mask) != mask) {
            throw INVALID_PADDING;
        }
        return baos.toByteArray();
    }

    private static Node buildTree(int[] codes, byte[] lengths) {
        Node root = new Node();
        for (int i = 0; i < codes.length; ++i) {
            HuffmanDecoder.insert(root, i, codes[i], lengths[i]);
        }
        return root;
    }

    private static void insert(Node root, int symbol, int code, byte length) {
        Node current = root;
        while (length > 8) {
            if (current.isTerminal()) {
                throw new IllegalStateException("invalid Huffman code: prefix not unique");
            }
            length = (byte)(length - 8);
            int i = code >>> length & 0xFF;
            if (current.children[i] == null) {
                ((Node)current).children[i] = new Node();
            }
            current = current.children[i];
        }
        Node terminal = new Node(symbol, length);
        int shift = 8 - length;
        int start = code << shift & 0xFF;
        int end = 1 << shift;
        for (int i = start; i < start + end; ++i) {
            ((Node)current).children[i] = terminal;
        }
    }

    static {
        EOS_DECODED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        INVALID_PADDING.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
    }

    private static final class Node {
        private final int symbol;
        private final int bits;
        private final Node[] children;

        private Node() {
            this.symbol = 0;
            this.bits = 8;
            this.children = new Node[256];
        }

        private Node(int symbol, int bits) {
            assert (bits > 0 && bits <= 8);
            this.symbol = symbol;
            this.bits = bits;
            this.children = null;
        }

        private boolean isTerminal() {
            return this.children == null;
        }
    }
}

