/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;

public enum ObjectType {
    STRING(Function.identity()),
    BYTE(Byte::parseByte),
    SHORT(Short::parseShort),
    INTEGER(Integer::parseInt),
    LONG(Long::parseLong),
    FLOAT(Float::parseFloat),
    DOUBLE(Double::parseDouble),
    CHARACTER(s -> Character.valueOf(s.charAt(0))),
    BOOLEAN(Boolean::parseBoolean),
    JSON_OBJECT(JsonObject::new),
    JSON_ARRAY(JsonArray::new),
    BUFFER(Buffer::buffer),
    BASE64(s -> {
        byte[] bytes = Base64.getDecoder().decode((String)s);
        return Buffer.buffer((byte[])bytes);
    }),
    HEX(s -> Buffer.buffer((byte[])DatatypeConverter.parseHexBinary((String)s)));

    final Function<String, ?> parser;

    private ObjectType(Function<String, ?> parser) {
        this.parser = parser;
    }
}

