/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.shell.command;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.ext.shell.command.Command;
import io.vertx.rxjava.ext.shell.command.CommandResolver;
import java.util.List;
import java.util.stream.Collectors;
import rx.Observable;

public class CommandRegistry
extends CommandResolver {
    final io.vertx.ext.shell.command.CommandRegistry delegate;

    public CommandRegistry(io.vertx.ext.shell.command.CommandRegistry delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    public static CommandRegistry getShared(io.vertx.rxjava.core.Vertx vertx) {
        CommandRegistry ret = CommandRegistry.newInstance(io.vertx.ext.shell.command.CommandRegistry.getShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CommandRegistry create(io.vertx.rxjava.core.Vertx vertx) {
        CommandRegistry ret = CommandRegistry.newInstance(io.vertx.ext.shell.command.CommandRegistry.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public CommandRegistry registerCommand(Command command) {
        this.delegate.registerCommand((io.vertx.ext.shell.command.Command)command.getDelegate());
        return this;
    }

    public CommandRegistry registerCommand(Command command, final Handler<AsyncResult<Command>> completionHandler) {
        this.delegate.registerCommand((io.vertx.ext.shell.command.Command)command.getDelegate(), new Handler<AsyncResult<io.vertx.ext.shell.command.Command>>(){

            public void handle(AsyncResult<io.vertx.ext.shell.command.Command> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)Command.newInstance((io.vertx.ext.shell.command.Command)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<Command> registerCommandObservable(Command command) {
        ObservableFuture completionHandler = RxHelper.observableFuture();
        this.registerCommand(command, (Handler<AsyncResult<Command>>)completionHandler.toHandler());
        return completionHandler;
    }

    public CommandRegistry registerCommands(List<Command> commands) {
        this.delegate.registerCommands(commands.stream().map(elt -> (io.vertx.ext.shell.command.Command)elt.getDelegate()).collect(Collectors.toList()));
        return this;
    }

    public CommandRegistry registerCommands(List<Command> commands, final Handler<AsyncResult<List<Command>>> completionHandler) {
        this.delegate.registerCommands(commands.stream().map(elt -> (io.vertx.ext.shell.command.Command)elt.getDelegate()).collect(Collectors.toList()), new Handler<AsyncResult<List<io.vertx.ext.shell.command.Command>>>(){

            public void handle(AsyncResult<List<io.vertx.ext.shell.command.Command>> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> Command.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<List<Command>> registerCommandsObservable(List<Command> commands) {
        ObservableFuture completionHandler = RxHelper.observableFuture();
        this.registerCommands(commands, (Handler<AsyncResult<List<Command>>>)completionHandler.toHandler());
        return completionHandler;
    }

    public CommandRegistry unregisterCommand(String commandName) {
        this.delegate.unregisterCommand(commandName);
        return this;
    }

    public CommandRegistry unregisterCommand(String commandName, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.unregisterCommand(commandName, completionHandler);
        return this;
    }

    public Observable<Void> unregisterCommandObservable(String commandName) {
        ObservableFuture completionHandler = RxHelper.observableFuture();
        this.unregisterCommand(commandName, (Handler<AsyncResult<Void>>)completionHandler.toHandler());
        return completionHandler;
    }

    public static CommandRegistry newInstance(io.vertx.ext.shell.command.CommandRegistry arg) {
        return arg != null ? new CommandRegistry(arg) : null;
    }
}

