/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Decorator;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.HelperRegistry;
import com.github.jknack.handlebars.helper.BlockHelper;
import com.github.jknack.handlebars.helper.EachHelper;
import com.github.jknack.handlebars.helper.EmbeddedHelper;
import com.github.jknack.handlebars.helper.I18nHelper;
import com.github.jknack.handlebars.helper.IfHelper;
import com.github.jknack.handlebars.helper.InlineDecorator;
import com.github.jknack.handlebars.helper.LogHelper;
import com.github.jknack.handlebars.helper.LookupHelper;
import com.github.jknack.handlebars.helper.MethodHelper;
import com.github.jknack.handlebars.helper.PartialHelper;
import com.github.jknack.handlebars.helper.PrecompileHelper;
import com.github.jknack.handlebars.helper.UnlessHelper;
import com.github.jknack.handlebars.helper.WithHelper;
import com.github.jknack.handlebars.internal.Files;
import com.github.jknack.handlebars.js.HandlebarsJs;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHelperRegistry
implements HelperRegistry {
    private final Logger logger = LoggerFactory.getLogger(HelperRegistry.class);
    private final Map<String, Helper<?>> helpers = new HashMap();
    private final Map<String, Decorator> decorators = new HashMap<String, Decorator>();
    private HandlebarsJs handlebarsJs = HandlebarsJs.create(this);

    public DefaultHelperRegistry() {
        DefaultHelperRegistry.registerBuiltinsHelpers(this);
    }

    @Override
    public <C> Helper<C> helper(String name) {
        Validate.notEmpty(name, "A helper's name is required.", new Object[0]);
        return this.helpers.get(name);
    }

    @Override
    public <H> HelperRegistry registerHelper(String name, Helper<H> helper) {
        Validate.notEmpty(name, "A helper's name is required.", new Object[0]);
        Validate.notNull(helper, "A helper is required.", new Object[0]);
        Helper<H> oldHelper = this.helpers.put(name, helper);
        if (oldHelper != null) {
            this.logger.warn("Helper '{}' has been replaced by '{}'", (Object)name, helper);
        }
        return this;
    }

    @Override
    public <H> HelperRegistry registerHelperMissing(Helper<H> helper) {
        return this.registerHelper("helperMissing", helper);
    }

    @Override
    public HelperRegistry registerHelpers(Object helperSource) {
        Validate.notNull(helperSource, "The helper source is required.", new Object[0]);
        Validate.isTrue(!(helperSource instanceof String), "java.lang.String isn't a helper source.", new Object[0]);
        try {
            if (helperSource instanceof File) {
                return this.registerHelpers((File)helperSource);
            }
            if (helperSource instanceof URI) {
                return this.registerHelpers((URI)helperSource);
            }
            if (helperSource instanceof Class) {
                return this.registerHelpers((Class)helperSource);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't register helpres", ex);
        }
        this.registerDynamicHelper(helperSource, helperSource.getClass());
        return this;
    }

    @Override
    public HelperRegistry registerHelpers(Class<?> helperSource) {
        Validate.notNull(helperSource, "The helper source is required.", new Object[0]);
        if (Enum.class.isAssignableFrom(helperSource)) {
            Enum[] helpers;
            for (Enum helper : helpers = (Enum[])helperSource.getEnumConstants()) {
                Validate.isTrue(helper instanceof Helper, "'%s' isn't a helper.", helper.name());
                this.registerHelper(helper.name(), (Helper)((Object)helper));
            }
        } else {
            this.registerDynamicHelper(null, helperSource);
        }
        return this;
    }

    @Override
    public HelperRegistry registerHelpers(URI location) throws Exception {
        return this.registerHelpers(location.getPath(), Files.read(location.toString()));
    }

    @Override
    public HelperRegistry registerHelpers(File input) throws Exception {
        return this.registerHelpers(input.getAbsolutePath(), Files.read(input));
    }

    @Override
    public HelperRegistry registerHelpers(String filename, Reader source) throws Exception {
        return this.registerHelpers(filename, Files.read(source));
    }

    @Override
    public HelperRegistry registerHelpers(String filename, InputStream source) throws Exception {
        return this.registerHelpers(filename, Files.read(source));
    }

    @Override
    public HelperRegistry registerHelpers(String filename, String source) throws Exception {
        Validate.notNull(filename, "The filename is required.", new Object[0]);
        Validate.notEmpty(source, "The source is required.", new Object[0]);
        this.handlebarsJs.registerHelpers(filename, source);
        return this;
    }

    @Override
    public Set<Map.Entry<String, Helper<?>>> helpers() {
        return this.helpers.entrySet();
    }

    private void registerDynamicHelper(Object source, Class<?> clazz) {
        if (clazz != Object.class) {
            Method[] methods;
            HashSet<String> overloaded = new HashSet<String>();
            for (Method method : methods = clazz.getDeclaredMethods()) {
                boolean isPublic = Modifier.isPublic(method.getModifiers());
                String helperName = method.getName();
                if (!isPublic || !CharSequence.class.isAssignableFrom(method.getReturnType())) continue;
                boolean isStatic = Modifier.isStatic(method.getModifiers());
                if (source == null && !isStatic) continue;
                Validate.isTrue(overloaded.add(helperName), "name conflict found: " + helperName, new Object[0]);
                this.registerHelper(helperName, new MethodHelper(method, source));
            }
        }
    }

    private static void registerBuiltinsHelpers(HelperRegistry registry) {
        registry.registerHelper("with", WithHelper.INSTANCE);
        registry.registerHelper("if", IfHelper.INSTANCE);
        registry.registerHelper("unless", UnlessHelper.INSTANCE);
        registry.registerHelper("each", EachHelper.INSTANCE);
        registry.registerHelper("embedded", EmbeddedHelper.INSTANCE);
        registry.registerHelper("block", BlockHelper.INSTANCE);
        registry.registerHelper("partial", PartialHelper.INSTANCE);
        registry.registerHelper("precompile", PrecompileHelper.INSTANCE);
        registry.registerHelper("i18n", I18nHelper.i18n);
        registry.registerHelper("i18nJs", I18nHelper.i18nJs);
        registry.registerHelper("lookup", LookupHelper.INSTANCE);
        registry.registerHelper("log", LogHelper.INSTANCE);
        registry.registerDecorator("inline", InlineDecorator.INSTANCE);
    }

    @Override
    public Decorator decorator(String name) {
        Validate.notEmpty(name, "A decorator's name is required.", new Object[0]);
        return this.decorators.get(name);
    }

    @Override
    public HelperRegistry registerDecorator(String name, Decorator decorator) {
        Validate.notEmpty(name, "A decorator's name is required.", new Object[0]);
        Validate.notNull(decorator, "A decorator is required.", new Object[0]);
        Decorator old = this.decorators.put(name, decorator);
        if (old != null) {
            this.logger.warn("Decorator '{}' has been replaced by '{}'", (Object)name, (Object)decorator);
        }
        return this;
    }

    public DefaultHelperRegistry with(HandlebarsJs handlebarsJs) {
        Validate.notNull(handlebarsJs, "The handlebarsJs is required.", new Object[0]);
        this.handlebarsJs = handlebarsJs;
        return this;
    }
}

