/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.impl;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import io.vertx.ext.web.templ.HandlebarsTemplateEngine;
import io.vertx.ext.web.templ.impl.CachingTemplateEngine;
import java.io.IOException;

public class HandlebarsTemplateEngineImpl
extends CachingTemplateEngine<Template>
implements HandlebarsTemplateEngine {
    private final Handlebars handlebars;
    private final Loader loader = new Loader();

    public HandlebarsTemplateEngineImpl() {
        super("hbs", 10000);
        this.handlebars = new Handlebars(this.loader);
    }

    @Override
    public HandlebarsTemplateEngine setExtension(String extension) {
        this.doSetExtension(extension);
        return this;
    }

    @Override
    public HandlebarsTemplateEngine setMaxCacheSize(int maxCacheSize) {
        this.cache.setMaxSize(maxCacheSize);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RoutingContext context, String templateFileName, Handler<AsyncResult<Buffer>> handler) {
        try {
            Template template = (Template)this.cache.get((Object)templateFileName);
            if (template == null) {
                HandlebarsTemplateEngineImpl handlebarsTemplateEngineImpl = this;
                synchronized (handlebarsTemplateEngineImpl) {
                    this.loader.setVertx(context.vertx());
                    template = this.handlebars.compile(templateFileName);
                    this.cache.put((Object)templateFileName, (Object)template);
                }
            }
            handler.handle((Object)Future.succeededFuture((Object)Buffer.buffer((String)template.apply(context.data()))));
        }
        catch (Exception ex) {
            handler.handle((Object)Future.failedFuture((Throwable)ex));
        }
    }

    @Override
    public Handlebars getHandlebars() {
        return this.handlebars;
    }

    private class Loader
    implements TemplateLoader {
        private Vertx vertx;

        private Loader() {
        }

        void setVertx(Vertx vertx) {
            this.vertx = vertx;
        }

        @Override
        public TemplateSource sourceAt(String location) throws IOException {
            final String loc = HandlebarsTemplateEngineImpl.this.adjustLocation(location);
            final String templ = Utils.readFileToString((Vertx)this.vertx, (String)loc);
            if (templ == null) {
                throw new IllegalArgumentException("Cannot find resource " + loc);
            }
            final long lastMod = System.currentTimeMillis();
            return new TemplateSource(){

                @Override
                public String content() throws IOException {
                    return templ;
                }

                @Override
                public String filename() {
                    return loc;
                }

                @Override
                public long lastModified() {
                    return lastMod;
                }
            };
        }

        @Override
        public String resolve(String location) {
            return location;
        }

        @Override
        public String getPrefix() {
            return null;
        }

        @Override
        public String getSuffix() {
            return HandlebarsTemplateEngineImpl.this.extension;
        }

        @Override
        public void setPrefix(String prefix) {
        }

        @Override
        public void setSuffix(String suffix) {
            HandlebarsTemplateEngineImpl.this.extension = suffix;
        }
    }
}

