/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;

public abstract class COMUtils {
    public static final int S_OK = 0;
    public static final int S_FALSE = 1;
    public static final int REGDB_E_CLASSNOTREG = -2147221164;
    public static final int CLASS_E_NOAGGREGATION = -2147221232;
    public static final int CO_E_NOTINITIALIZED = -2147221008;
    public static final int E_UNEXPECTED = -2147418113;
    public static final int E_NOTIMPL = -2147467263;
    public static final int E_OUTOFMEMORY = -2147024882;
    public static final int E_INVALIDARG = -2147024809;
    public static final int E_NOINTERFACE = -2147467262;
    public static final int E_POINTER = -2147467261;
    public static final int E_HANDLE = -2147024890;
    public static final int E_ABORT = -2147467260;
    public static final int E_FAIL = -2147467259;
    public static final int E_ACCESSDENIED = -2147024891;
    public static final int DISP_E_BADVARTYPE = -2147352568;
    public static final int DISP_E_NOTACOLLECTION = -2147352559;
    public static final int DISP_E_MEMBERNOTFOUND = -2147352573;
    public static final int DISP_E_ARRAYISLOCKED = -2147352563;
    public static final int DISP_E_EXCEPTION = -2147352567;
    public static final int DISP_E_TYPEMISMATCH = -2147352571;
    public static final int DISP_E_BADINDEX = -2147352565;
    public static final int DISP_E_BADCALLEE = -2147352560;
    public static final int DISP_E_OVERFLOW = -2147352566;
    public static final int DISP_E_UNKNOWNINTERFACE = -2147352575;
    public static final int DISP_E_DIVBYZERO = -2147352558;
    public static final int DISP_E_UNKNOWNLCID = -2147352564;
    public static final int DISP_E_PARAMNOTOPTIONAL = -2147352561;
    public static final int DISP_E_PARAMNOTFOUND = -2147352572;
    public static final int DISP_E_BADPARAMCOUNT = -2147352562;
    public static final int DISP_E_BUFFERTOOSMALL = -2147352557;
    public static final int DISP_E_UNKNOWNNAME = -2147352570;
    public static final int DISP_E_NONAMEDARGS = -2147352569;
    public static final int CO_E_OBJNOTCONNECTED = -2147220995;

    public static boolean SUCCEEDED(WinNT.HRESULT hr) {
        return COMUtils.SUCCEEDED(hr.intValue());
    }

    public static boolean SUCCEEDED(int hr) {
        return hr == 0;
    }

    public static boolean FAILED(WinNT.HRESULT hr) {
        return COMUtils.FAILED(hr.intValue());
    }

    public static boolean FAILED(int hr) {
        return hr != 0;
    }

    public static void checkAutoRC(WinNT.HRESULT hr) {
        COMUtils.checkAutoRC(hr, null, null);
    }

    public static void checkAutoRC(WinNT.HRESULT hr, OaIdl.EXCEPINFO pExcepInfo, IntByReference puArgErr) {
        switch (hr.intValue()) {
            case 0: {
                return;
            }
            case -2147467263: {
                throw new COMException("Not implemented!");
            }
            case -2147024809: {
                throw new COMException("Invalid argument!");
            }
            case -2147024882: {
                throw new COMException("Out of memory!");
            }
            case -2147418113: {
                throw new COMException("Error " + Integer.toHexString(hr.intValue()));
            }
            case -2147221008: {
                throw new COMException("CoInitialized wasn't called!");
            }
            case -2147467262: {
                throw new COMException("Interface does not inherit from class!");
            }
            case -2147467261: {
                throw new COMException("Allocated pointer pointer is null!");
            }
            case -2147352570: {
                throw new COMException("One or more of the names were not known. The returned array of DISPIDs contains DISPID_UNKNOWN for each entry that corresponds to an unknown name!");
            }
            case -2147352564: {
                throw new COMException("The locale identifier (LCID) was not recognized!");
            }
            case -2147352562: {
                throw new COMException("The number of elements provided to DISPPARAMS is different from the number of arguments accepted by the method or property!");
            }
            case -2147352568: {
                throw new COMException("One of the arguments in DISPPARAMS is not a valid variant type!");
            }
            case -2147352567: {
                throw new COMException("The application needs to raise an exception. In this case, the structure passed in pexcepinfo should be filled in!", pExcepInfo, puArgErr);
            }
            case -2147352573: {
                throw new COMException("The requested member does not exist!");
            }
            case -2147352569: {
                throw new COMException("This implementation of IDispatch does not support named arguments!");
            }
            case -2147352566: {
                throw new COMException("One of the arguments in DISPPARAMS could not be coerced to the specified type!");
            }
            case -2147352572: {
                throw new COMException("One of the parameter IDs does not correspond to a parameter on the method. In this case, puArgErr is set to the first argument that contains the error!", pExcepInfo, puArgErr);
            }
            case -2147352571: {
                throw new COMException("One or more of the arguments could not be coerced. The index of the first parameter with the incorrect type within rgvarg is returned in puArgErr!", pExcepInfo, puArgErr);
            }
            case -2147352575: {
                throw new COMException("The interface identifier passed in riid is not IID_NULL!");
            }
            case -2147220995: {
                throw new COMException("The method is not connected to the Dispatch pointer!");
            }
        }
        throw new COMException("Unexpected COM error code : " + COMUtils.toHexStr(hr));
    }

    public static void checkTypeLibRC(WinNT.HRESULT hr) {
        switch (hr.intValue()) {
            case 0: {
                return;
            }
            case -2147024809: {
                throw new COMException("One or more of the arguments is not valid.");
            }
            case -2147024882: {
                throw new COMException("Insufficient memory to complete the operation.");
            }
            case -2147316574: {
                throw new COMException("The function could not write to the file.");
            }
            case -2147319767: {
                throw new COMException("The type library could not be opened.");
            }
            case -2147319784: {
                throw new COMException("The function could not read from the file. ");
            }
            case -2147319783: {
                throw new COMException("The type library has an older format.");
            }
            case -2147319762: {
                throw new COMException("The LCID could not be found in the OLE-supported DLLs.");
            }
            case -2147312566: {
                throw new COMException("The type library or DLL could not be loaded.");
            }
            case -2147319765: {
                throw new COMException("No type description was found in the library with the specified GUID.");
            }
        }
        throw new COMException("Unexpected Typelib error code : " + COMUtils.toHexStr(hr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<COMInfo> getAllCOMInfoOnSystem() {
        WinReg.HKEYByReference phkResult = new WinReg.HKEYByReference();
        WinReg.HKEYByReference phkResult2 = new WinReg.HKEYByReference();
        ArrayList<COMInfo> comInfos = new ArrayList<COMInfo>();
        try {
            phkResult = Advapi32Util.registryGetKey(WinReg.HKEY_CLASSES_ROOT, "CLSID", 2031679);
            Advapi32Util.InfoKey infoKey = Advapi32Util.registryQueryInfoKey(phkResult.getValue(), 2031679);
            for (int i = 0; i < infoKey.lpcSubKeys.getValue(); ++i) {
                Advapi32Util.EnumKey enumKey = Advapi32Util.registryRegEnumKey(phkResult.getValue(), i);
                String subKey = Native.toString((char[])enumKey.lpName);
                COMInfo comInfo = new COMInfo(subKey);
                phkResult2 = Advapi32Util.registryGetKey(phkResult.getValue(), subKey, 2031679);
                Advapi32Util.InfoKey infoKey2 = Advapi32Util.registryQueryInfoKey(phkResult2.getValue(), 2031679);
                for (int y = 0; y < infoKey2.lpcSubKeys.getValue(); ++y) {
                    Advapi32Util.EnumKey enumKey2 = Advapi32Util.registryRegEnumKey(phkResult2.getValue(), y);
                    String subKey2 = Native.toString((char[])enumKey2.lpName);
                    if (subKey2.equals("InprocHandler32")) {
                        comInfo.inprocHandler32 = (String)Advapi32Util.registryGetValue(phkResult2.getValue(), subKey2, null);
                        continue;
                    }
                    if (subKey2.equals("InprocServer32")) {
                        comInfo.inprocServer32 = (String)Advapi32Util.registryGetValue(phkResult2.getValue(), subKey2, null);
                        continue;
                    }
                    if (subKey2.equals("LocalServer32")) {
                        comInfo.localServer32 = (String)Advapi32Util.registryGetValue(phkResult2.getValue(), subKey2, null);
                        continue;
                    }
                    if (subKey2.equals("ProgID")) {
                        comInfo.progID = (String)Advapi32Util.registryGetValue(phkResult2.getValue(), subKey2, null);
                        continue;
                    }
                    if (!subKey2.equals("TypeLib")) continue;
                    comInfo.typeLib = (String)Advapi32Util.registryGetValue(phkResult2.getValue(), subKey2, null);
                }
                Advapi32.INSTANCE.RegCloseKey(phkResult2.getValue());
                comInfos.add(comInfo);
            }
        }
        finally {
            Advapi32.INSTANCE.RegCloseKey(phkResult.getValue());
            Advapi32.INSTANCE.RegCloseKey(phkResult2.getValue());
        }
        return comInfos;
    }

    private static String toHexStr(WinNT.HRESULT hr) {
        return "0x" + Integer.toHexString(hr.intValue()).toUpperCase();
    }

    public static class COMInfo {
        public String clsid;
        public String inprocHandler32;
        public String inprocServer32;
        public String localServer32;
        public String progID;
        public String typeLib;

        public COMInfo() {
        }

        public COMInfo(String clsid) {
            this.clsid = clsid;
        }
    }
}

