/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.store;

import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.config.store.ITimeoutConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.io.file.Files;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import de.flapdoodle.embed.process.store.IDownloader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public class Downloader
implements IDownloader {
    static final int DEFAULT_CONTENT_LENGTH = 0x1400000;
    static final int BUFFER_LENGTH = 65536;
    static final int READ_COUNT_MULTIPLIER = 100;

    @Override
    public String getDownloadUrl(IDownloadConfig runtime, Distribution distribution) {
        return runtime.getDownloadPath().getPath(distribution) + runtime.getPackageResolver().getPath(distribution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File download(IDownloadConfig downloadConfig, Distribution distribution) throws IOException {
        String progressLabel = "Download " + distribution;
        IProgressListener progress = downloadConfig.getProgressListener();
        progress.start(progressLabel);
        File ret = Files.createTempFile(PropertyOrPlatformTempDir.defaultInstance(), downloadConfig.getFileNaming().nameFor(downloadConfig.getDownloadPrefix(), "." + (Object)((Object)downloadConfig.getPackageResolver().getArchiveType(distribution))));
        if (ret.canWrite()) {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(ret));
            InputStreamAndLength downloadStreamAndLength = this.downloadInputStream(downloadConfig, distribution);
            long length = downloadStreamAndLength.contentLength();
            InputStream downloadStream = downloadStreamAndLength.downloadStream();
            progress.info(progressLabel, "DownloadSize: " + length);
            if (length == -1L) {
                length = 0x1400000L;
            }
            long downloadStartedAt = System.currentTimeMillis();
            try {
                BufferedInputStream bis = new BufferedInputStream(downloadStream);
                byte[] buf = new byte[65536];
                int read = 0;
                long readCount = 0L;
                while ((read = bis.read(buf)) != -1) {
                    bos.write(buf, 0, read);
                    if ((readCount += (long)read) > length) {
                        length = readCount;
                    }
                    progress.progress(progressLabel, (int)(readCount * 100L / length));
                }
                progress.info(progressLabel, "downloaded with " + this.downloadSpeed(downloadStartedAt, length));
            }
            finally {
                downloadStream.close();
                bos.flush();
                bos.close();
            }
        } else {
            throw new IOException("Can not write " + ret);
        }
        progress.done(progressLabel);
        return ret;
    }

    private InputStreamAndLength downloadInputStream(IDownloadConfig downloadConfig, Distribution distribution) throws MalformedURLException, IOException {
        URL url = new URL(this.getDownloadUrl(downloadConfig, distribution));
        Proxy proxy = downloadConfig.proxyFactory().createProxy();
        try {
            URLConnection openConnection = proxy != null ? url.openConnection(proxy) : url.openConnection();
            openConnection.setRequestProperty("User-Agent", downloadConfig.getUserAgent());
            ITimeoutConfig timeoutConfig = downloadConfig.getTimeoutConfig();
            openConnection.setConnectTimeout(timeoutConfig.getConnectionTimeout());
            openConnection.setReadTimeout(downloadConfig.getTimeoutConfig().getReadTimeout());
            InputStream downloadStream = openConnection.getInputStream();
            return new InputStreamAndLength(downloadStream, openConnection.getContentLength());
        }
        catch (IOException iox) {
            throw new IOException("Could not open inputStream for " + url + (proxy != null ? " with proxy " + proxy : ""), iox);
        }
    }

    private String downloadSpeed(long downloadStartedAt, long downloadSize) {
        long timeUsed = (System.currentTimeMillis() - downloadStartedAt) / 1000L;
        if (timeUsed == 0L) {
            timeUsed = 1L;
        }
        long kbPerSecond = downloadSize / (timeUsed * 1024L);
        return "" + kbPerSecond + "kb/s";
    }

    static class InputStreamAndLength {
        private final InputStream _downloadStream;
        private final int _contentLength;

        public InputStreamAndLength(InputStream downloadStream, int contentLength) {
            this._downloadStream = downloadStream;
            this._contentLength = contentLength;
        }

        public int contentLength() {
            return this._contentLength;
        }

        public InputStream downloadStream() {
            return this._downloadStream;
        }
    }
}

