/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.eventbus.SendContext;
import io.vertx.core.eventbus.impl.CodecManager;
import io.vertx.core.eventbus.impl.HandlerHolder;
import io.vertx.core.eventbus.impl.HandlerRegistration;
import io.vertx.core.eventbus.impl.Handlers;
import io.vertx.core.eventbus.impl.MessageImpl;
import io.vertx.core.eventbus.impl.MessageProducerImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class EventBusImpl
implements EventBus,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(EventBusImpl.class);
    private final List<Handler<SendContext>> interceptors = new CopyOnWriteArrayList<Handler<SendContext>>();
    private final AtomicLong replySequence = new AtomicLong(0L);
    protected final VertxInternal vertx;
    protected final EventBusMetrics metrics;
    protected final ConcurrentMap<String, Handlers> handlerMap = new ConcurrentHashMap<String, Handlers>();
    protected final CodecManager codecManager = new CodecManager();
    protected volatile boolean started;

    public EventBusImpl(VertxInternal vertx) {
        this.vertx = vertx;
        this.metrics = vertx.metricsSPI().createMetrics(this);
    }

    @Override
    public EventBus addInterceptor(Handler<SendContext> interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    @Override
    public EventBus removeInterceptor(Handler<SendContext> interceptor) {
        this.interceptors.remove(interceptor);
        return this;
    }

    @Override
    public synchronized void start(Handler<AsyncResult<Void>> completionHandler) {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        completionHandler.handle(Future.succeededFuture());
    }

    @Override
    public EventBus send(String address, Object message) {
        return this.send(address, message, new DeliveryOptions(), null);
    }

    @Override
    public <T> EventBus send(String address, Object message, Handler<AsyncResult<Message<T>>> replyHandler) {
        return this.send(address, message, new DeliveryOptions(), replyHandler);
    }

    @Override
    public EventBus send(String address, Object message, DeliveryOptions options) {
        return this.send(address, message, options, null);
    }

    @Override
    public <T> EventBus send(String address, Object message, DeliveryOptions options, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.sendOrPubInternal(this.createMessage(true, address, options.getHeaders(), message, options.getCodecName()), options, replyHandler);
        return this;
    }

    @Override
    public <T> MessageProducer<T> sender(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, true, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> sender(String address, DeliveryOptions options) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options, "options");
        return new MessageProducerImpl(this.vertx, address, true, options);
    }

    @Override
    public <T> MessageProducer<T> publisher(String address) {
        Objects.requireNonNull(address, "address");
        return new MessageProducerImpl(this.vertx, address, false, new DeliveryOptions());
    }

    @Override
    public <T> MessageProducer<T> publisher(String address, DeliveryOptions options) {
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(options, "options");
        return new MessageProducerImpl(this.vertx, address, false, options);
    }

    @Override
    public EventBus publish(String address, Object message) {
        return this.publish(address, message, new DeliveryOptions());
    }

    @Override
    public EventBus publish(String address, Object message, DeliveryOptions options) {
        this.sendOrPubInternal(this.createMessage(false, address, options.getHeaders(), message, options.getCodecName()), options, null);
        return this;
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new HandlerRegistration(this.vertx, this.metrics, this, address, null, false, null, -1L);
    }

    @Override
    public <T> MessageConsumer<T> consumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.consumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address) {
        this.checkStarted();
        Objects.requireNonNull(address, "address");
        return new HandlerRegistration(this.vertx, this.metrics, this, address, null, true, null, -1L);
    }

    @Override
    public <T> MessageConsumer<T> localConsumer(String address, Handler<Message<T>> handler) {
        Objects.requireNonNull(handler, "handler");
        MessageConsumer<T> consumer = this.localConsumer(address);
        consumer.handler((Handler)handler);
        return consumer;
    }

    @Override
    public EventBus registerCodec(MessageCodec codec) {
        this.codecManager.registerCodec(codec);
        return this;
    }

    @Override
    public EventBus unregisterCodec(String name) {
        this.codecManager.unregisterCodec(name);
        return this;
    }

    @Override
    public <T> EventBus registerDefaultCodec(Class<T> clazz, MessageCodec<T, ?> codec) {
        this.codecManager.registerDefaultCodec(clazz, codec);
        return this;
    }

    @Override
    public EventBus unregisterDefaultCodec(Class clazz) {
        this.codecManager.unregisterDefaultCodec(clazz);
        return this;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.checkStarted();
        this.unregisterAll();
        if (this.metrics != null) {
            this.metrics.close();
        }
        if (completionHandler != null) {
            this.vertx.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null && this.metrics.isEnabled();
    }

    @Override
    public EventBusMetrics<?> getMetrics() {
        return this.metrics;
    }

    protected MessageImpl createMessage(boolean send, String address, MultiMap headers, Object body, String codecName) {
        Objects.requireNonNull(address, "no null address accepted");
        MessageCodec codec = this.codecManager.lookupCodec(body, codecName);
        MessageImpl msg = new MessageImpl(address, null, headers, body, codec, send, this);
        return msg;
    }

    protected <T> void addRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly) {
        Objects.requireNonNull(registration.getHandler(), "handler");
        boolean newAddress = this.addLocalRegistration(address, registration, replyHandler, localOnly);
        this.addRegistration(newAddress, address, replyHandler, localOnly, registration::setResult);
    }

    protected <T> void addRegistration(boolean newAddress, String address, boolean replyHandler, boolean localOnly, Handler<AsyncResult<Void>> completionHandler) {
        completionHandler.handle(Future.succeededFuture());
    }

    protected <T> boolean addLocalRegistration(String address, HandlerRegistration<T> registration, boolean replyHandler, boolean localOnly) {
        boolean hasContext;
        Objects.requireNonNull(address, "address");
        Context context = Vertx.currentContext();
        boolean bl = hasContext = context != null;
        if (!hasContext) {
            context = this.vertx.getOrCreateContext();
        }
        registration.setHandlerContext(context);
        boolean newAddress = false;
        HandlerHolder<T> holder = new HandlerHolder<T>(this.metrics, registration, replyHandler, localOnly, context);
        Handlers handlers = (Handlers)this.handlerMap.get(address);
        if (handlers == null) {
            handlers = new Handlers();
            Handlers prevHandlers = this.handlerMap.putIfAbsent(address, handlers);
            if (prevHandlers != null) {
                handlers = prevHandlers;
            }
            newAddress = true;
        }
        handlers.list.add(holder);
        if (hasContext) {
            HandlerEntry<T> entry = new HandlerEntry<T>(address, registration);
            context.addCloseHook(entry);
        }
        return newAddress;
    }

    protected <T> void removeRegistration(String address, HandlerRegistration<T> handler, Handler<AsyncResult<Void>> completionHandler) {
        HandlerHolder holder = this.removeLocalRegistration(address, handler);
        this.removeRegistration(holder, address, completionHandler);
    }

    protected <T> void removeRegistration(HandlerHolder handlerHolder, String address, Handler<AsyncResult<Void>> completionHandler) {
        this.callCompletionHandlerAsync(completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> HandlerHolder removeLocalRegistration(String address, HandlerRegistration<T> handler) {
        Handlers handlers = (Handlers)this.handlerMap.get(address);
        HandlerHolder lastHolder = null;
        if (handlers != null) {
            Handlers handlers2 = handlers;
            synchronized (handlers2) {
                int size = handlers.list.size();
                for (int i = 0; i < size; ++i) {
                    HandlerHolder holder = handlers.list.get(i);
                    if (holder.getHandler() != handler) continue;
                    handlers.list.remove(i);
                    holder.setRemoved();
                    if (handlers.list.isEmpty()) {
                        this.handlerMap.remove(address);
                        lastHolder = holder;
                    }
                    holder.getContext().removeCloseHook(new HandlerEntry(address, holder.getHandler()));
                    break;
                }
            }
        }
        return lastHolder;
    }

    protected <T> void sendReply(MessageImpl replyMessage, MessageImpl replierMessage, DeliveryOptions options, Handler<AsyncResult<Message<T>>> replyHandler) {
        if (replyMessage.address() == null) {
            throw new IllegalStateException("address not specified");
        }
        HandlerRegistration<T> replyHandlerRegistration = this.createReplyHandlerRegistration(replyMessage, options, replyHandler);
        new ReplySendContextImpl<T>(replyMessage, options, replyHandlerRegistration, replierMessage).next();
    }

    protected <T> void sendReply(SendContextImpl<T> sendContext, MessageImpl replierMessage) {
        this.sendOrPub(sendContext);
    }

    protected <T> void sendOrPub(SendContextImpl<T> sendContext) {
        MessageImpl message = sendContext.message;
        this.metrics.messageSent(message.address(), !message.send(), true, false);
        this.deliverMessageLocally(sendContext);
    }

    protected <T> Handler<Message<T>> convertHandler(Handler<AsyncResult<Message<T>>> handler) {
        return reply -> {
            Future result;
            if (reply.body() instanceof ReplyException) {
                ReplyException exception = (ReplyException)reply.body();
                this.metrics.replyFailure(reply.address(), exception.failureType());
                result = Future.failedFuture(exception);
            } else {
                result = Future.succeededFuture(reply);
            }
            handler.handle(result);
        };
    }

    protected void callCompletionHandlerAsync(Handler<AsyncResult<Void>> completionHandler) {
        if (completionHandler != null) {
            this.vertx.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
    }

    protected <T> void deliverMessageLocally(SendContextImpl<T> sendContext) {
        if (!this.deliverMessageLocally(sendContext.message)) {
            this.metrics.replyFailure(sendContext.message.address, ReplyFailure.NO_HANDLERS);
            if (sendContext.handlerRegistration != null) {
                sendContext.handlerRegistration.sendAsyncResultFailure(ReplyFailure.NO_HANDLERS, "No handlers for address " + sendContext.message.address);
            }
        }
    }

    protected boolean isMessageLocal(MessageImpl msg) {
        return true;
    }

    protected <T> boolean deliverMessageLocally(MessageImpl msg) {
        msg.setBus(this);
        Handlers handlers = (Handlers)this.handlerMap.get(msg.address());
        if (handlers != null) {
            if (msg.send()) {
                HandlerHolder holder = handlers.choose();
                if (holder != null) {
                    this.metrics.messageReceived(msg.address(), !msg.send(), this.isMessageLocal(msg), 1);
                    this.deliverToHandler(msg, holder);
                }
            } else {
                this.metrics.messageReceived(msg.address(), !msg.send(), this.isMessageLocal(msg), handlers.list.size());
                for (HandlerHolder holder : handlers.list) {
                    this.deliverToHandler(msg, holder);
                }
            }
            return true;
        }
        this.metrics.messageReceived(msg.address(), !msg.send(), this.isMessageLocal(msg), 0);
        return false;
    }

    protected void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Event Bus is not started");
        }
    }

    protected String generateReplyAddress() {
        return Long.toString(this.replySequence.incrementAndGet());
    }

    private <T> HandlerRegistration<T> createReplyHandlerRegistration(MessageImpl message, DeliveryOptions options, Handler<AsyncResult<Message<T>>> replyHandler) {
        if (replyHandler != null) {
            long timeout = options.getSendTimeout();
            String replyAddress = this.generateReplyAddress();
            message.setReplyAddress(replyAddress);
            Handler<Message<T>> simpleReplyHandler = this.convertHandler(replyHandler);
            HandlerRegistration<T> registration = new HandlerRegistration<T>(this.vertx, this.metrics, this, replyAddress, message.address, true, replyHandler, timeout);
            registration.handler((Handler)simpleReplyHandler);
            return registration;
        }
        return null;
    }

    private <T> void sendOrPubInternal(MessageImpl message, DeliveryOptions options, Handler<AsyncResult<Message<T>>> replyHandler) {
        this.checkStarted();
        HandlerRegistration<T> replyHandlerRegistration = this.createReplyHandlerRegistration(message, options, replyHandler);
        SendContextImpl<T> sendContext = new SendContextImpl<T>(message, options, replyHandlerRegistration);
        sendContext.next();
    }

    private void unregisterAll() {
        for (Handlers handlers : this.handlerMap.values()) {
            for (HandlerHolder holder : handlers.list) {
                holder.getHandler().unregister(true);
            }
        }
    }

    private <T> void deliverToHandler(MessageImpl msg, HandlerHolder<T> holder) {
        MessageImpl copied = msg.copyBeforeReceive();
        holder.getContext().runOnContext(v -> {
            try {
                if (!holder.isRemoved()) {
                    holder.getHandler().handle(copied);
                }
            }
            finally {
                if (holder.isReplyHandler()) {
                    holder.getHandler().unregister();
                }
            }
        });
    }

    protected void finalize() throws Throwable {
        this.close(ar -> {});
        super.finalize();
    }

    public class HandlerEntry<T>
    implements Closeable {
        final String address;
        final HandlerRegistration<T> handler;

        public HandlerEntry(String address, HandlerRegistration<T> handler) {
            this.address = address;
            this.handler = handler;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            HandlerEntry entry = (HandlerEntry)o;
            if (!this.address.equals(entry.address)) {
                return false;
            }
            return this.handler.equals(entry.handler);
        }

        public int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + (this.handler != null ? this.handler.hashCode() : 0);
            return result;
        }

        @Override
        public void close(Handler<AsyncResult<Void>> completionHandler) {
            this.handler.unregister(completionHandler);
            completionHandler.handle(Future.succeededFuture());
        }
    }

    protected class ReplySendContextImpl<T>
    extends SendContextImpl<T> {
        private final MessageImpl replierMessage;

        public ReplySendContextImpl(MessageImpl message, DeliveryOptions options, HandlerRegistration<T> handlerRegistration, MessageImpl replierMessage) {
            super(message, options, handlerRegistration);
            this.replierMessage = replierMessage;
        }

        @Override
        public void next() {
            if (this.iter.hasNext()) {
                Handler handler = (Handler)this.iter.next();
                handler.handle(this);
            } else {
                EventBusImpl.this.sendReply(this, this.replierMessage);
            }
        }
    }

    protected class SendContextImpl<T>
    implements SendContext<T> {
        public final MessageImpl message;
        public final DeliveryOptions options;
        public final HandlerRegistration<T> handlerRegistration;
        public final Iterator<Handler<SendContext>> iter;

        public SendContextImpl(MessageImpl message, DeliveryOptions options, HandlerRegistration<T> handlerRegistration) {
            this.message = message;
            this.options = options;
            this.handlerRegistration = handlerRegistration;
            this.iter = EventBusImpl.this.interceptors.iterator();
        }

        @Override
        public Message<T> message() {
            return this.message;
        }

        @Override
        public void next() {
            if (this.iter.hasNext()) {
                Handler<SendContext> handler = this.iter.next();
                try {
                    handler.handle(this);
                }
                catch (Throwable t) {
                    log.error((Object)"Failure in interceptor", t);
                }
            } else {
                EventBusImpl.this.sendOrPub(this);
            }
        }

        @Override
        public boolean send() {
            return this.message.send();
        }
    }
}

