/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.HostsFileParser;
import io.netty.resolver.InetSocketAddressResolver;
import io.netty.resolver.NameResolver;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.dns.impl.fix.DnsNameResolver;
import io.vertx.core.dns.impl.fix.DnsNameResolverBuilder;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxImpl;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AddressResolver {
    private static final String DISABLE_DNS_RESOLVER_PROP_NAME = "vertx.disableDnsResolver";
    private static final boolean DISABLE_DNS_RESOLVER = Boolean.getBoolean("vertx.disableDnsResolver");
    private final Vertx vertx;
    private final AddressResolverGroup<InetSocketAddress> resolverGroup;

    public AddressResolver(VertxImpl vertx, AddressResolverOptions options) {
        if (!DISABLE_DNS_RESOLVER) {
            final DnsNameResolverBuilder builder = new DnsNameResolverBuilder(null);
            builder.channelType(NioDatagramChannel.class);
            if (options != null) {
                Map entries;
                List<String> dnsServers = options.getServers();
                if (dnsServers != null && dnsServers.size() > 0) {
                    ArrayList<InetSocketAddress> serverList = new ArrayList<InetSocketAddress>();
                    for (String dnsServer : dnsServers) {
                        int port;
                        String ipAddress;
                        int sep = dnsServer.indexOf(58);
                        if (sep != -1) {
                            ipAddress = dnsServer.substring(0, sep);
                            port = Integer.parseInt(dnsServer.substring(sep + 1));
                        } else {
                            ipAddress = dnsServer;
                            port = 53;
                        }
                        try {
                            serverList.add(new InetSocketAddress(InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString((String)ipAddress)), port));
                        }
                        catch (UnknownHostException e) {
                            throw new VertxException(e);
                        }
                    }
                    DnsServerAddresses nameServerAddresses = DnsServerAddresses.sequential(serverList);
                    builder.nameServerAddresses(nameServerAddresses);
                }
                if (options.getHostsPath() != null) {
                    File file = vertx.resolveFile(options.getHostsPath()).getAbsoluteFile();
                    try {
                        if (!file.exists() || !file.isFile()) {
                            throw new IOException();
                        }
                        entries = HostsFileParser.parse((File)file);
                    }
                    catch (IOException e) {
                        throw new VertxException("Cannot read hosts file " + file.getAbsolutePath());
                    }
                } else if (options.getHostsValue() != null) {
                    try {
                        entries = HostsFileParser.parse((Reader)new StringReader(options.getHostsValue().toString()));
                    }
                    catch (IOException e) {
                        throw new VertxException("Cannot read hosts config ", e);
                    }
                } else {
                    entries = HostsFileParser.parseSilently();
                }
                try {
                    if (!entries.containsKey("localhost")) {
                        entries.put("localhost", InetAddress.getByName("localhost"));
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                builder.hostsFileEntriesResolver(inetHost -> {
                    InetAddress addr = (InetAddress)entries.get(inetHost);
                    if (addr == null) {
                        addr = (InetAddress)entries.get(inetHost.toLowerCase(Locale.ENGLISH));
                    }
                    return addr;
                });
                builder.optResourceEnabled(options.isOptResourceEnabled());
                builder.ttl(options.getCacheMinTimeToLive(), options.getCacheMaxTimeToLive());
                builder.negativeTtl(options.getCacheNegativeTimeToLive());
                builder.queryTimeoutMillis(options.getQueryTimeout());
                builder.maxQueriesPerResolve(options.getMaxQueries());
                builder.recursionDesired(options.getRdFlag());
                if (options.getSearchDomains() != null) {
                    builder.searchDomains(options.getSearchDomains());
                    builder.ndots(options.getNdots());
                }
            }
            this.resolverGroup = new AddressResolverGroup<InetSocketAddress>(){

                protected io.netty.resolver.AddressResolver<InetSocketAddress> newResolver(EventExecutor executor) throws Exception {
                    final DnsNameResolver resolver = builder.build((EventLoop)executor);
                    return new InetSocketAddressResolver(executor, (NameResolver)resolver){

                        public void close() {
                            resolver.close();
                        }
                    };
                }
            };
        } else {
            this.resolverGroup = DefaultAddressResolverGroup.INSTANCE;
        }
        this.vertx = vertx;
    }

    public void resolveHostname(String hostname, Handler<AsyncResult<InetAddress>> resultHandler) {
        ContextInternal callback = (ContextInternal)this.vertx.getOrCreateContext();
        io.netty.resolver.AddressResolver resolver = this.resolverGroup.getResolver((EventExecutor)callback.nettyEventLoop());
        io.netty.util.concurrent.Future fut = resolver.resolve((SocketAddress)InetSocketAddress.createUnresolved(hostname, 0));
        fut.addListener(a -> callback.runOnContext(v -> {
            if (a.isSuccess()) {
                InetSocketAddress address = (InetSocketAddress)fut.getNow();
                resultHandler.handle(Future.succeededFuture(address.getAddress()));
            } else {
                resultHandler.handle(Future.failedFuture(a.cause()));
            }
        }));
    }

    public AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.resolverGroup;
    }

    public void close() {
        this.resolverGroup.close();
    }
}

