/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemTrustOptions;
import java.util.Base64;
import java.util.stream.Collectors;

public class PemTrustOptionsConverter {
    public static void fromJson(JsonObject json, PemTrustOptions obj) {
        if (json.getValue("certPaths") instanceof JsonArray) {
            json.getJsonArray("certPaths").forEach(item -> {
                if (item instanceof String) {
                    obj.addCertPath((String)item);
                }
            });
        }
        if (json.getValue("certValues") instanceof JsonArray) {
            json.getJsonArray("certValues").forEach(item -> {
                if (item instanceof String) {
                    obj.addCertValue(Buffer.buffer(Base64.getDecoder().decode((String)item)));
                }
            });
        }
    }

    public static void toJson(PemTrustOptions obj, JsonObject json) {
        if (obj.getCertPaths() != null) {
            json.put("certPaths", new JsonArray(obj.getCertPaths().stream().map(item -> item).collect(Collectors.toList())));
        }
        if (obj.getCertValues() != null) {
            json.put("certValues", new JsonArray(obj.getCertValues().stream().map(item -> item.getBytes()).collect(Collectors.toList())));
        }
    }
}

