/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import co.paralleluniverse.common.monitoring.ExecutorServiceLatencyProbe;
import co.paralleluniverse.common.monitoring.ForkJoinPoolMonitor;
import co.paralleluniverse.common.monitoring.Metrics;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.ForkJoinPool;

public class MetricsForkJoinPoolMonitor
extends ForkJoinPoolMonitor {
    public MetricsForkJoinPoolMonitor(String name, ForkJoinPool fjPool) {
        super(name, fjPool);
        Metrics.register(this.metric(name, "status"), new Gauge<ForkJoinPoolMonitor.Status>(){

            public ForkJoinPoolMonitor.Status getValue() {
                ForkJoinPool fjPool = MetricsForkJoinPoolMonitor.this.fjPool();
                if (fjPool.isTerminated()) {
                    return ForkJoinPoolMonitor.Status.TERMINATED;
                }
                if (fjPool.isTerminating()) {
                    return ForkJoinPoolMonitor.Status.TERMINATING;
                }
                if (fjPool.isShutdown()) {
                    return ForkJoinPoolMonitor.Status.SHUTDOWN;
                }
                if (fjPool.isQuiescent()) {
                    return ForkJoinPoolMonitor.Status.QUIESCENT;
                }
                return ForkJoinPoolMonitor.Status.ACTIVE;
            }
        });
        Metrics.register(this.metric(name, "asyncMode"), new Gauge<Boolean>(){

            public Boolean getValue() {
                return MetricsForkJoinPoolMonitor.this.fjPool().getAsyncMode();
            }
        });
        Metrics.register(this.metric(name, "parallelism"), new Gauge<Integer>(){

            public Integer getValue() {
                return MetricsForkJoinPoolMonitor.this.fjPool().getParallelism();
            }
        });
        Metrics.register(this.metric(name, "poolSize"), new Gauge<Integer>(){

            public Integer getValue() {
                return MetricsForkJoinPoolMonitor.this.fjPool().getPoolSize();
            }
        });
        Metrics.register(this.metric(name, "activeThreadCount"), new Gauge<Integer>(){

            public Integer getValue() {
                return MetricsForkJoinPoolMonitor.this.fjPool().getActiveThreadCount();
            }
        });
        Metrics.register(this.metric(name, "runningThreadCount"), new Gauge<Integer>(){

            public Integer getValue() {
                return MetricsForkJoinPoolMonitor.this.fjPool().getRunningThreadCount();
            }
        });
        Metrics.register(this.metric(name, "queuedSubmissionCount"), new Gauge<Integer>(){

            public Integer getValue() {
                return MetricsForkJoinPoolMonitor.this.fjPool().getQueuedSubmissionCount();
            }
        });
        Metrics.register(this.metric(name, "queuedTaskCount"), new Gauge<Long>(){

            public Long getValue() {
                return MetricsForkJoinPoolMonitor.this.fjPool().getQueuedTaskCount();
            }
        });
        Metrics.register(this.metric(name, "stealCount"), new Gauge<Long>(){

            public Long getValue() {
                return MetricsForkJoinPoolMonitor.this.fjPool().getStealCount();
            }
        });
        Metrics.register(this.metric(name, "latency"), new Gauge<Long[]>(){

            public Long[] getValue() {
                long[] res = new ExecutorServiceLatencyProbe(MetricsForkJoinPoolMonitor.this.fjPool(), 5).fire();
                Long[] ret = new Long[res.length];
                for (int i = 0; i < res.length; ++i) {
                    ret[i] = res[i];
                }
                return ret;
            }
        });
    }

    protected final String metric(String poolName, String name) {
        return MetricRegistry.name((String)"co.paralleluniverse", (String[])new String[]{"fjPool", poolName, name});
    }

    @Override
    protected ForkJoinPool fjPool() {
        ForkJoinPool fjPool = super.fjPool();
        if (fjPool == null) {
            this.unregister();
            throw new RuntimeException("Pool collected");
        }
        return fjPool;
    }
}

